/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.List;
import java.util.Objects;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.minestom.server.instance.block.predicate.BlockTypeFilter;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Tool(@NotNull List<Rule> rules, float defaultMiningSpeed, int damagePerBlock) {
    public static final float DEFAULT_MINING_SPEED = 1.0f;
    public static final int DEFAULT_DAMAGE_PER_BLOCK = 1;
    public static final NetworkBuffer.Type<Tool> NETWORK_TYPE = new NetworkBuffer.Type<Tool>(){
        private static final NetworkBuffer.Type<List<Rule>> RULE_LIST_TYPE = Rule.NETWORK_TYPE.list(Short.MAX_VALUE);

        @Override
        public void write(@NotNull NetworkBuffer buffer, Tool value) {
            RULE_LIST_TYPE.write(buffer, value.rules());
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.defaultMiningSpeed()));
            buffer.write(NetworkBuffer.VAR_INT, value.damagePerBlock());
        }

        @Override
        public Tool read(@NotNull NetworkBuffer buffer) {
            return new Tool(RULE_LIST_TYPE.read(buffer), buffer.read(NetworkBuffer.FLOAT).floatValue(), buffer.read(NetworkBuffer.VAR_INT));
        }
    };
    public static final BinaryTagSerializer<Tool> NBT_TYPE = new BinaryTagSerializer<Tool>(){
        private static final BinaryTagSerializer<List<Rule>> RULE_LIST_TYPE = Rule.NBT_TYPE.list();

        @Override
        @NotNull
        public BinaryTag write(@NotNull Tool value) {
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().put("rules", RULE_LIST_TYPE.write(value.rules()))).putFloat("default_mining_speed", value.defaultMiningSpeed())).putInt("damage_per_block", value.damagePerBlock())).build();
        }

        @Override
        @NotNull
        public Tool read(@NotNull BinaryTag tag) {
            if (!(tag instanceof CompoundBinaryTag)) {
                throw new IllegalArgumentException("Expected a compound tag, got " + String.valueOf(tag.type()));
            }
            CompoundBinaryTag compound = (CompoundBinaryTag)tag;
            return new Tool(RULE_LIST_TYPE.read(Objects.requireNonNull(compound.get("rules"))), compound.getFloat("default_mining_speed", 1.0f), compound.getInt("damage_per_block", 1));
        }
    };

    public record Rule(@NotNull BlockTypeFilter blocks, @Nullable Float speed, @Nullable Boolean correctForDrops) {
        public static final NetworkBuffer.Type<Rule> NETWORK_TYPE = new NetworkBuffer.Type<Rule>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Rule value) {
                buffer.write(BlockTypeFilter.NETWORK_TYPE, value.blocks());
                buffer.writeOptional(NetworkBuffer.FLOAT, value.speed());
                buffer.writeOptional(NetworkBuffer.BOOLEAN, value.correctForDrops());
            }

            @Override
            public Rule read(@NotNull NetworkBuffer buffer) {
                return new Rule(buffer.read(BlockTypeFilter.NETWORK_TYPE), buffer.readOptional(NetworkBuffer.FLOAT), buffer.readOptional(NetworkBuffer.BOOLEAN));
            }
        };
        public static final BinaryTagSerializer<Rule> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
            ByteBinaryTag correctForDrops;
            Float f;
            BinaryTag patt0$temp = tag.get("speed");
            if (patt0$temp instanceof FloatBinaryTag) {
                FloatBinaryTag speed = (FloatBinaryTag)patt0$temp;
                f = Float.valueOf(speed.floatValue());
            } else {
                f = null;
            }
            BinaryTag patt1$temp = tag.get("correctForDrops");
            return new Rule(BlockTypeFilter.NBT_TYPE.read(Objects.requireNonNull(tag.get("blocks"))), f, patt1$temp instanceof ByteBinaryTag ? Boolean.valueOf((correctForDrops = (ByteBinaryTag)patt1$temp).value() != 0) : null);
        }, rule -> {
            CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
            builder.put("blocks", BlockTypeFilter.NBT_TYPE.write(rule.blocks()));
            if (rule.speed() != null) {
                builder.putFloat("speed", rule.speed().floatValue());
            }
            if (rule.correctForDrops() != null) {
                builder.putBoolean("correct_for_drops", rule.correctForDrops().booleanValue());
            }
            return builder.build();
        });
    }
}

