/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import java.util.List;
import net.minestom.server.entity.Player;
import net.minestom.server.inventory.click.Click;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.client.play.ClientCreativeInventoryActionPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;

public final class CreativeInventoryActionListener {
    public static void listener(ClientCreativeInventoryActionPacket packet, Player player) {
        int slot;
        if (!player.isCreative()) {
            return;
        }
        ItemStack item = packet.item();
        if (packet.slot() == -1) {
            player.getInventory().handleClick(player, new Click.Info.CreativeDropItem(item), List.of(new Click.Change.DropFromPlayer(item)));
        }
        if ((slot = PlayerInventoryUtils.protocolToMinestom(packet.slot())) == -1) {
            return;
        }
        player.getInventory().handleClick(player, new Click.Info.CreativeSetItem(slot, item), List.of(new Click.Change.Container(slot, item)));
    }
}

