/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import java.util.List;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryButtonClickEvent;
import net.minestom.server.event.inventory.InventoryCloseEvent;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.click.Click;
import net.minestom.server.network.packet.client.common.ClientPongPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowButtonPacket;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.network.packet.client.play.ClientCloseWindowPacket;
import net.minestom.server.network.packet.server.common.PingPacket;
import net.minestom.server.utils.inventory.ClickUtils;

public class WindowListener {
    public static void clickWindowListener(ClientClickWindowPacket packet, Player player) {
        Inventory inventory;
        byte windowId = packet.windowId();
        boolean playerInventory = windowId == 0;
        Inventory inventory2 = inventory = playerInventory ? player.getInventory() : player.getOpenInventory();
        if (inventory == null || packet.slot() == -1) {
            return;
        }
        Click.Preprocessor preprocessor = player.clickPreprocessor();
        Click.Info info = preprocessor.processClick(packet, player.isCreative(), playerInventory ? null : Integer.valueOf(inventory.getSize()));
        if (info != null) {
            Click.Getter getter = ClickUtils.makeGetter(inventory, player.getInventory());
            List<Click.Change> clientPrediction = ClickUtils.packetToChanges(packet, info, getter, playerInventory);
            inventory.handleClick(player, info, clientPrediction);
        }
        player.sendPacket(new PingPacket(0x40000000 | windowId << 16));
    }

    public static void pong(ClientPongPacket packet, Player player) {
    }

    public static void closeWindowListener(ClientCloseWindowPacket packet, Player player) {
        Inventory openInventory = player.getOpenInventory();
        if (openInventory == null) {
            return;
        }
        InventoryCloseEvent inventoryCloseEvent = new InventoryCloseEvent(openInventory, player);
        EventDispatcher.call(inventoryCloseEvent);
        if (player.getOpenInventory() != openInventory) {
            return;
        }
        if (inventoryCloseEvent.isCancelled()) {
            player.UNSAFE_changeSkipClosePacket(true);
            openInventory.removeViewer(player);
            openInventory.addViewer(player);
        } else {
            player.closeInventory(true);
        }
    }

    public static void buttonClickListener(ClientClickWindowButtonPacket packet, Player player) {
        Inventory openInventory = player.getOpenInventory();
        if (openInventory == null) {
            openInventory = player.getInventory();
        }
        InventoryButtonClickEvent event = new InventoryButtonClickEvent(openInventory, player, packet.buttonId());
        EventDispatcher.call(event);
    }
}

