/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener.preplay;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.extras.bungee.BungeeCordProxy;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.client.handshake.ClientHandshakePacket;
import net.minestom.server.network.packet.server.login.LoginDisconnectPacket;
import net.minestom.server.network.player.GameProfile;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.network.player.PlayerSocketConnection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HandshakeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandshakeListener.class);
    private static final Component INVALID_VERSION_TEXT = Component.text((String)"Invalid Version, please use 1.20.6", (TextColor)NamedTextColor.RED);
    private static final Component INVALID_BUNGEE_FORWARDING = Component.text((String)"Invalid connection, please connect through the BungeeCord proxy. If you believe this is an error, contact a server administrator.", (TextColor)NamedTextColor.RED);

    public static void listener(@NotNull ClientHandshakePacket packet, @NotNull PlayerConnection connection) {
        String address = packet.serverAddress();
        switch (packet.intent()) {
            case STATUS: {
                connection.setConnectionState(ConnectionState.STATUS);
                break;
            }
            case LOGIN: {
                connection.setConnectionState(ConnectionState.LOGIN);
                if (packet.protocolVersion() != 766) {
                    HandshakeListener.disconnect(connection, INVALID_VERSION_TEXT);
                }
                if (!BungeeCordProxy.isEnabled() || !(connection instanceof PlayerSocketConnection)) break;
                PlayerSocketConnection socketConnection = (PlayerSocketConnection)connection;
                String[] split = address.split("\u0000");
                if (split.length == 3 || split.length == 4) {
                    boolean hasProperties;
                    boolean bl = hasProperties = split.length == 4;
                    if (BungeeCordProxy.isBungeeGuardEnabled() && !hasProperties) {
                        HandshakeListener.bungeeDisconnect(socketConnection);
                        return;
                    }
                    address = split[0];
                    InetSocketAddress socketAddress = new InetSocketAddress(split[1], ((InetSocketAddress)connection.getRemoteAddress()).getPort());
                    socketConnection.setRemoteAddress(socketAddress);
                    UUID playerUuid = UUID.fromString(split[2].replaceFirst("(\\p{XDigit}{8})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}{4})(\\p{XDigit}+)", "$1-$2-$3-$4-$5"));
                    ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>();
                    if (hasProperties) {
                        boolean foundBungeeGuardToken = false;
                        String rawPropertyJson = split[3];
                        JsonArray propertyJson = JsonParser.parseString((String)rawPropertyJson).getAsJsonArray();
                        for (JsonElement element : propertyJson) {
                            String signatureString;
                            JsonObject jsonObject = element.getAsJsonObject();
                            JsonElement name = jsonObject.get("name");
                            JsonElement value = jsonObject.get("value");
                            JsonElement signature = jsonObject.get("signature");
                            if (name == null || value == null) continue;
                            String nameString = name.getAsString();
                            String valueString = value.getAsString();
                            String string = signatureString = signature == null ? null : signature.getAsString();
                            if (BungeeCordProxy.isBungeeGuardEnabled() && nameString.equals("bungeeguard-token")) {
                                if (foundBungeeGuardToken || !BungeeCordProxy.isValidBungeeGuardToken(valueString)) {
                                    HandshakeListener.bungeeDisconnect(socketConnection);
                                    return;
                                }
                                foundBungeeGuardToken = true;
                            }
                            properties.add(new GameProfile.Property(nameString, valueString, signatureString));
                        }
                        if (BungeeCordProxy.isBungeeGuardEnabled() && !foundBungeeGuardToken) {
                            HandshakeListener.bungeeDisconnect(socketConnection);
                            return;
                        }
                    }
                    GameProfile gameProfile = new GameProfile(playerUuid, "test", properties);
                    socketConnection.UNSAFE_setProfile(gameProfile);
                    break;
                }
                HandshakeListener.bungeeDisconnect(socketConnection);
                return;
            }
            case TRANSFER: {
                throw new UnsupportedOperationException("Transfer intent is not supported in HandshakeListener");
            }
        }
        if (connection instanceof PlayerSocketConnection) {
            ((PlayerSocketConnection)connection).refreshServerInformation(address, packet.serverPort(), packet.protocolVersion());
        }
    }

    private static void disconnect(@NotNull PlayerConnection connection, @NotNull Component reason) {
        connection.sendPacket(new LoginDisconnectPacket(reason));
        connection.disconnect();
    }

    private static void bungeeDisconnect(@NotNull PlayerConnection connection) {
        LOGGER.warn("{} tried to log in without valid BungeeGuard forwarding information.", (Object)connection.getIdentifier());
        HandshakeListener.disconnect(connection, INVALID_BUNGEE_FORWARDING);
    }
}

