/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.metadata.animal.ArmadilloMeta;
import net.minestom.server.entity.metadata.animal.FrogMeta;
import net.minestom.server.entity.metadata.animal.SnifferMeta;
import net.minestom.server.entity.metadata.animal.tameable.CatMeta;
import net.minestom.server.entity.metadata.other.PaintingMeta;
import net.minestom.server.network.NetworkBufferTypeImpl;
import net.minestom.server.network.packet.server.play.data.WorldPos;
import net.minestom.server.particle.Particle;
import net.minestom.server.utils.Direction;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.nbt.BinaryTagReader;
import net.minestom.server.utils.nbt.BinaryTagWriter;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class NetworkBuffer {
    public static final Type<Unit> UNIT = new NetworkBufferTypeImpl.UnitType();
    public static final Type<Boolean> BOOLEAN = new NetworkBufferTypeImpl.BooleanType();
    public static final Type<Byte> BYTE = new NetworkBufferTypeImpl.ByteType();
    public static final Type<Short> SHORT = new NetworkBufferTypeImpl.ShortType();
    public static final Type<Integer> UNSIGNED_SHORT = new NetworkBufferTypeImpl.UnsignedShortType();
    public static final Type<Integer> INT = new NetworkBufferTypeImpl.IntType();
    public static final Type<Long> LONG = new NetworkBufferTypeImpl.LongType();
    public static final Type<Float> FLOAT = new NetworkBufferTypeImpl.FloatType();
    public static final Type<Double> DOUBLE = new NetworkBufferTypeImpl.DoubleType();
    public static final Type<Integer> VAR_INT = new NetworkBufferTypeImpl.VarIntType();
    public static final Type<Long> VAR_LONG = new NetworkBufferTypeImpl.VarLongType();
    public static final Type<byte[]> RAW_BYTES = new NetworkBufferTypeImpl.RawBytesType();
    public static final Type<String> STRING = new NetworkBufferTypeImpl.StringType();
    public static final Type<BinaryTag> NBT = new NetworkBufferTypeImpl.NbtType();
    public static final Type<Point> BLOCK_POSITION = new NetworkBufferTypeImpl.BlockPositionType();
    public static final Type<Component> COMPONENT = new NetworkBufferTypeImpl.ComponentType();
    public static final Type<Component> JSON_COMPONENT = new NetworkBufferTypeImpl.JsonComponentType();
    public static final Type<UUID> UUID = new NetworkBufferTypeImpl.UUIDType();
    public static final Type<byte[]> BYTE_ARRAY = new NetworkBufferTypeImpl.ByteArrayType();
    public static final Type<long[]> LONG_ARRAY = new NetworkBufferTypeImpl.LongArrayType();
    public static final Type<int[]> VAR_INT_ARRAY = new NetworkBufferTypeImpl.VarIntArrayType();
    public static final Type<long[]> VAR_LONG_ARRAY = new NetworkBufferTypeImpl.VarLongArrayType();
    public static final Type<Integer> BLOCK_STATE = new NetworkBufferTypeImpl.BlockStateType();
    public static final Type<int[]> VILLAGER_DATA = new NetworkBufferTypeImpl.VillagerDataType();
    public static final Type<WorldPos> DEATH_LOCATION = new NetworkBufferTypeImpl.DeathLocationType();
    public static final Type<Point> VECTOR3 = new NetworkBufferTypeImpl.Vector3Type();
    public static final Type<Point> VECTOR3D = new NetworkBufferTypeImpl.Vector3DType();
    public static final Type<float[]> QUATERNION = new NetworkBufferTypeImpl.QuaternionType();
    public static final Type<Particle> PARTICLE = new NetworkBufferTypeImpl.ParticleType();
    public static final Type<Component> OPT_CHAT = NetworkBufferTypeImpl.fromOptional(COMPONENT);
    public static final Type<Point> OPT_BLOCK_POSITION = NetworkBufferTypeImpl.fromOptional(BLOCK_POSITION);
    public static final Type<UUID> OPT_UUID = NetworkBufferTypeImpl.fromOptional(UUID);
    public static final Type<Direction> DIRECTION = NetworkBufferTypeImpl.fromEnum(Direction.class);
    public static final Type<Entity.Pose> POSE = NetworkBufferTypeImpl.fromEnum(Entity.Pose.class);
    public static final Type<CatMeta.Variant> CAT_VARIANT = NetworkBufferTypeImpl.fromEnum(CatMeta.Variant.class);
    public static final Type<FrogMeta.Variant> FROG_VARIANT = NetworkBufferTypeImpl.fromEnum(FrogMeta.Variant.class);
    public static final Type<PaintingMeta.Variant> PAINTING_VARIANT = NetworkBufferTypeImpl.fromEnum(PaintingMeta.Variant.class);
    public static final Type<SnifferMeta.State> SNIFFER_STATE = NetworkBufferTypeImpl.fromEnum(SnifferMeta.State.class);
    public static final Type<ArmadilloMeta.State> ARMADILLO_STATE = NetworkBufferTypeImpl.fromEnum(ArmadilloMeta.State.class);
    ByteBuffer nioBuffer;
    final boolean resizable;
    int writeIndex;
    int readIndex;
    BinaryTagWriter nbtWriter;
    BinaryTagReader nbtReader;

    public static <E extends Enum<E>> Type<E> fromEnum(@NotNull Class<E> enumClass) {
        return NetworkBufferTypeImpl.fromEnum(enumClass);
    }

    public static <T> Type<T> lazy(final @NotNull Supplier<Type<T>> supplier) {
        return new Type<T>(){
            private Type<T> type;

            @Override
            public void write(@NotNull NetworkBuffer buffer, T value) {
                if (this.type == null) {
                    this.type = (Type)supplier.get();
                }
                this.type.write(buffer, value);
            }

            @Override
            public T read(@NotNull NetworkBuffer buffer) {
                if (this.type == null) {
                    this.type = (Type)supplier.get();
                }
                return null;
            }
        };
    }

    public NetworkBuffer(@NotNull ByteBuffer buffer, boolean resizable) {
        this.nioBuffer = buffer.order(ByteOrder.BIG_ENDIAN);
        this.resizable = resizable;
        this.writeIndex = buffer.position();
        this.readIndex = buffer.position();
    }

    public NetworkBuffer(@NotNull ByteBuffer buffer) {
        this(buffer, true);
    }

    public NetworkBuffer(int initialCapacity) {
        this(ByteBuffer.allocateDirect(initialCapacity), true);
    }

    public NetworkBuffer() {
        this(1024);
    }

    public <T> void write(@NotNull Type<T> type, @NotNull T value) {
        type.write(this, value);
    }

    public <T> void write(@NotNull Writer writer) {
        writer.write(this);
    }

    @NotNull
    public <T> T read(@NotNull Type<T> type) {
        return type.read(this);
    }

    public <T> void writeOptional(@NotNull Type<T> type, @Nullable T value) {
        this.write(BOOLEAN, value != null);
        if (value != null) {
            this.write(type, value);
        }
    }

    public void writeOptional(@Nullable Writer writer) {
        this.write(BOOLEAN, writer != null);
        if (writer != null) {
            this.write(writer);
        }
    }

    @Nullable
    public <T> T readOptional(@NotNull Type<T> type) {
        return this.read(BOOLEAN) != false ? (T)this.read(type) : null;
    }

    @Nullable
    public <T> T readOptional(@NotNull @NotNull Function<@NotNull NetworkBuffer, @NotNull T> function) {
        return this.read(BOOLEAN) != false ? (T)function.apply(this) : null;
    }

    public <T> void writeCollection(@NotNull Type<T> type, @Nullable Collection<@NotNull T> values) {
        if (values == null) {
            this.write(BYTE, (byte)0);
            return;
        }
        this.write(VAR_INT, values.size());
        for (T value : values) {
            this.write(type, value);
        }
    }

    @SafeVarargs
    public final <T> void writeCollection(@NotNull Type<T> type, T ... values) {
        this.writeCollection(type, (Collection<T>)(values == null ? null : List.of(values)));
    }

    public <T extends Writer> void writeCollection(@Nullable Collection<@NotNull T> values) {
        if (values == null) {
            this.write(BYTE, (byte)0);
            return;
        }
        this.write(VAR_INT, values.size());
        for (Writer value : values) {
            this.write(value);
        }
    }

    public <T> void writeCollection(@Nullable Collection<@NotNull T> values, @NotNull @NotNull BiConsumer<@NotNull NetworkBuffer, @NotNull T> consumer) {
        if (values == null) {
            this.write(BYTE, (byte)0);
            return;
        }
        this.write(VAR_INT, values.size());
        for (T value : values) {
            consumer.accept(this, (NetworkBuffer)value);
        }
    }

    @NotNull
    public <T> @NotNull List<@NotNull T> readCollection(@NotNull Type<T> type, int maxSize) {
        int size = this.read(VAR_INT);
        Check.argCondition(size > maxSize, "Collection size ({0}) is higher than the maximum allowed size ({1})", size, maxSize);
        ArrayList<T> values = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            values.add(this.read(type));
        }
        return values;
    }

    @NotNull
    public <T> @NotNull List<@NotNull T> readCollection(@NotNull @NotNull Function<@NotNull NetworkBuffer, @NotNull T> function, int maxSize) {
        int size = this.read(VAR_INT);
        Check.argCondition(size > maxSize, "Collection size ({0}) is higher than the maximum allowed size ({1})", size, maxSize);
        ArrayList<T> values = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            values.add(function.apply(this));
        }
        return values;
    }

    public <E extends Enum<?>> void writeEnum(@NotNull Class<E> enumClass, @NotNull E value) {
        this.write(VAR_INT, value.ordinal());
    }

    @NotNull
    public <E extends Enum<?>> E readEnum(@NotNull @NotNull Class<@NotNull E> enumClass) {
        return (E)((Enum[])enumClass.getEnumConstants())[this.read(VAR_INT)];
    }

    public <E extends Enum<E>> void writeEnumSet(EnumSet<E> enumSet, Class<E> enumType) {
        Enum[] values = (Enum[])enumType.getEnumConstants();
        BitSet bitSet = new BitSet(values.length);
        for (int i = 0; i < values.length; ++i) {
            bitSet.set(i, enumSet.contains(values[i]));
        }
        this.writeFixedBitSet(bitSet, values.length);
    }

    @NotNull
    public <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> enumType) {
        Enum[] values = (Enum[])enumType.getEnumConstants();
        BitSet bitSet = this.readFixedBitSet(values.length);
        EnumSet<Enum> enumSet = EnumSet.noneOf(enumType);
        for (int i = 0; i < values.length; ++i) {
            if (!bitSet.get(i)) continue;
            enumSet.add(values[i]);
        }
        return enumSet;
    }

    public void writeFixedBitSet(BitSet set, int length) {
        int setLength = set.length();
        if (setLength > length) {
            throw new IllegalArgumentException("BitSet is larger than expected size (" + setLength + ">" + length + ")");
        }
        byte[] array = set.toByteArray();
        this.write(RAW_BYTES, array);
    }

    @NotNull
    public BitSet readFixedBitSet(int length) {
        byte[] array = this.readBytes((length + 7) / 8);
        return BitSet.valueOf(array);
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.nioBuffer.get(this.readIndex, bytes, 0, length);
        this.readIndex += length;
        return bytes;
    }

    public void copyTo(int srcOffset, byte @NotNull [] dest, int destOffset, int length) {
        this.nioBuffer.get(srcOffset, dest, destOffset, length);
    }

    public byte @NotNull [] extractBytes(@NotNull @NotNull Consumer<@NotNull NetworkBuffer> extractor) {
        int startingPosition = this.readIndex();
        extractor.accept(this);
        int endingPosition = this.readIndex();
        byte[] output = new byte[endingPosition - startingPosition];
        this.copyTo(startingPosition, output, 0, output.length);
        return output;
    }

    public void clear() {
        this.writeIndex = 0;
        this.readIndex = 0;
    }

    public int writeIndex() {
        return this.writeIndex;
    }

    public int readIndex() {
        return this.readIndex;
    }

    public void writeIndex(int writeIndex) {
        this.writeIndex = writeIndex;
    }

    public void readIndex(int readIndex) {
        this.readIndex = readIndex;
    }

    public int skipWrite(int length) {
        int oldWriteIndex = this.writeIndex;
        this.writeIndex += length;
        return oldWriteIndex;
    }

    public int readableBytes() {
        return this.writeIndex - this.readIndex;
    }

    void ensureSize(int length) {
        if (!this.resizable) {
            return;
        }
        if (this.nioBuffer.capacity() < this.writeIndex + length) {
            int newCapacity = Math.max(this.nioBuffer.capacity() * 2, this.writeIndex + length);
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newCapacity);
            this.nioBuffer.position(0);
            newBuffer.put(this.nioBuffer);
            this.nioBuffer = newBuffer.clear();
        }
    }

    public static byte[] makeArray(@NotNull @NotNull Consumer<@NotNull NetworkBuffer> writing) {
        NetworkBuffer writer = new NetworkBuffer();
        writing.accept(writer);
        byte[] bytes = new byte[writer.writeIndex];
        writer.copyTo(0, bytes, 0, bytes.length);
        return bytes;
    }

    public static interface Type<T> {
        public void write(@NotNull NetworkBuffer var1, T var2);

        public T read(@NotNull NetworkBuffer var1);

        @NotNull
        default public <S> Type<S> map(final @NotNull Function<T, S> to, final @NotNull Function<S, T> from) {
            return new Type<S>(){

                @Override
                public void write(@NotNull NetworkBuffer buffer, S value) {
                    this.write(buffer, from.apply(value));
                }

                @Override
                public S read(@NotNull NetworkBuffer buffer) {
                    return to.apply(this.read(buffer));
                }
            };
        }

        @NotNull
        default public Type<List<T>> list(final int maxSize) {
            return new Type<List<T>>(){

                @Override
                public void write(@NotNull NetworkBuffer buffer, List<T> value) {
                    buffer.writeCollection(this, value);
                }

                @Override
                public List<T> read(@NotNull NetworkBuffer buffer) {
                    return buffer.readCollection(this, maxSize);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Writer {
        public void write(@NotNull NetworkBuffer var1);
    }

    @FunctionalInterface
    public static interface Reader<T> {
        @NotNull
        public T read(@NotNull NetworkBuffer var1);
    }
}

