/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Collection;
import java.util.List;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeInstance;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.entity.attribute.AttributeOperation;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;

public record EntityAttributesPacket(int entityId, List<AttributeInstance> properties) implements ServerPacket.Play
{
    public static final int MAX_ENTRIES = 1024;

    public EntityAttributesPacket {
        properties = List.copyOf(properties);
    }

    public EntityAttributesPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.readCollection(r -> {
            int id = reader.read(NetworkBuffer.VAR_INT);
            Attribute attribute = Attribute.fromId(id);
            Check.notNull(attribute, "Unknown attribute id: " + id);
            double value = reader.read(NetworkBuffer.DOUBLE);
            int modifierCount = reader.read(NetworkBuffer.VAR_INT);
            AttributeInstance instance = new AttributeInstance(attribute, null);
            for (int i = 0; i < modifierCount; ++i) {
                AttributeModifier modifier = new AttributeModifier(reader.read(NetworkBuffer.UUID), "", reader.read(NetworkBuffer.DOUBLE), AttributeOperation.fromId(reader.read(NetworkBuffer.BYTE).byteValue()));
                instance.addModifier(modifier);
            }
            return instance;
        }, 1024));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.entityId);
        writer.write(NetworkBuffer.VAR_INT, this.properties.size());
        for (AttributeInstance instance : this.properties) {
            Attribute attribute = instance.getAttribute();
            writer.write(NetworkBuffer.VAR_INT, attribute.id());
            writer.write(NetworkBuffer.DOUBLE, instance.getBaseValue());
            Collection<AttributeModifier> modifiers = instance.getModifiers();
            writer.write(NetworkBuffer.VAR_INT, modifiers.size());
            for (AttributeModifier modifier : modifiers) {
                writer.write(NetworkBuffer.UUID, modifier.getId());
                writer.write(NetworkBuffer.DOUBLE, modifier.getAmount());
                writer.write(NetworkBuffer.BYTE, (byte)modifier.getOperation().getId());
            }
        }
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.ENTITY_ATTRIBUTES;
    }
}

