/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.entity.GameMode;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.network.packet.server.play.data.WorldPos;
import org.jetbrains.annotations.NotNull;

public record RespawnPacket(int dimensionType, String worldName, long hashedSeed, GameMode gameMode, GameMode previousGameMode, boolean isDebug, boolean isFlat, WorldPos deathLocation, int portalCooldown, int copyData) implements ServerPacket.Play
{
    public static final int COPY_NONE = 0;
    public static final int COPY_ATTRIBUTES = 1;
    public static final int COPY_METADATA = 2;
    public static final int COPY_ALL = 3;

    public RespawnPacket(@NotNull NetworkBuffer reader) {
        this(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.STRING), reader.read(NetworkBuffer.LONG), GameMode.fromId(reader.read(NetworkBuffer.BYTE).byteValue()), GameMode.fromId(reader.read(NetworkBuffer.BYTE).byteValue()), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.BOOLEAN), reader.read(NetworkBuffer.DEATH_LOCATION), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.BYTE).byteValue());
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.write(NetworkBuffer.VAR_INT, this.dimensionType);
        writer.write(NetworkBuffer.STRING, this.worldName);
        writer.write(NetworkBuffer.LONG, this.hashedSeed);
        writer.write(NetworkBuffer.BYTE, this.gameMode.id());
        writer.write(NetworkBuffer.BYTE, this.previousGameMode.id());
        writer.write(NetworkBuffer.BOOLEAN, this.isDebug);
        writer.write(NetworkBuffer.BOOLEAN, this.isFlat);
        writer.write(NetworkBuffer.DEATH_LOCATION, this.deathLocation);
        writer.write(NetworkBuffer.VAR_INT, this.portalCooldown);
        writer.write(NetworkBuffer.BYTE, (byte)this.copyData);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.RESPAWN;
    }
}

