/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.ServerPacketIdentifier;
import net.minestom.server.statistic.StatisticCategory;
import org.jetbrains.annotations.NotNull;

public record StatisticsPacket(@NotNull List<Statistic> statistics) implements ServerPacket.Play
{
    public static final int MAX_ENTRIES = 16384;

    public StatisticsPacket(@NotNull List<Statistic> statistics) {
        statistics = List.copyOf(statistics);
    }

    public StatisticsPacket(@NotNull NetworkBuffer reader) {
        this(reader.readCollection(Statistic::new, 16384));
    }

    @Override
    public void write(@NotNull NetworkBuffer writer) {
        writer.writeCollection(this.statistics);
    }

    @Override
    public int playId() {
        return ServerPacketIdentifier.STATISTICS;
    }

    public record Statistic(@NotNull StatisticCategory category, int statisticId, int value) implements NetworkBuffer.Writer
    {
        public Statistic(@NotNull NetworkBuffer reader) {
            this(reader.readEnum(StatisticCategory.class), reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void write(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.category.ordinal());
            writer.write(NetworkBuffer.VAR_INT, this.statisticId);
            writer.write(NetworkBuffer.VAR_INT, this.value);
        }
    }
}

