/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.ping;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.ping.ServerListPingType;
import net.minestom.server.utils.identity.NamedAndIdentified;
import org.jetbrains.annotations.NotNull;

public class ResponseData {
    private static final Component DEFAULT_DESCRIPTION = Component.text((String)"Minestom Server");
    private final List<NamedAndIdentified> entries = new ArrayList<NamedAndIdentified>();
    private String version = "1.20.6";
    private int protocol = 766;
    private int maxPlayer;
    private int online = MinecraftServer.getConnectionManager().getOnlinePlayerCount();
    private Component description;
    private String favicon = "";
    private boolean playersHidden = false;

    public ResponseData() {
        this.maxPlayer = this.online + 1;
        this.description = DEFAULT_DESCRIPTION;
    }

    @Deprecated
    public void setName(String name) {
        this.setVersion(name);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setMaxPlayer(int maxPlayer) {
        this.maxPlayer = maxPlayer;
    }

    public int getMaxPlayer() {
        return this.maxPlayer;
    }

    public void setOnline(int online) {
        this.online = online;
    }

    public int getOnline() {
        return this.online;
    }

    @Deprecated
    public void addPlayer(Iterable<Player> players) {
        for (Player player : players) {
            this.addPlayer(player);
        }
    }

    @Deprecated
    public void addPlayer(Player player) {
        this.addEntry(player);
    }

    @Deprecated
    public void addPlayer(String name, UUID uuid) {
        this.addEntry(NamedAndIdentified.of(name, uuid));
    }

    @Deprecated
    public void addPlayer(String name) {
        this.addEntry(NamedAndIdentified.named(name));
    }

    @Deprecated
    public void clearPlayers() {
        this.clearEntries();
    }

    @Deprecated(forRemoval=true)
    public List<PingPlayer> getPlayers() {
        return this.entries.stream().map(entry -> PingPlayer.of(PlainComponentSerializer.plain().serialize(entry.getName()), entry.getUuid())).toList();
    }

    @Deprecated
    public void setDescription(String description) {
        this.description = LegacyComponentSerializer.legacySection().deserialize(description);
    }

    public void setDescription(Component description) {
        this.description = description;
    }

    public Component getDescription() {
        return this.description;
    }

    public void setFavicon(String favicon) {
        this.favicon = favicon;
    }

    public String getFavicon() {
        return this.favicon;
    }

    public void addEntry(@NotNull NamedAndIdentified entry) {
        this.entries.add(entry);
    }

    public void addEntries(NamedAndIdentified ... entries) {
        this.addEntries(Arrays.asList(entries));
    }

    public void addEntries(@NotNull Collection<? extends NamedAndIdentified> entries) {
        this.entries.addAll(entries);
    }

    public void clearEntries() {
        this.entries.clear();
    }

    @NotNull
    public Collection<NamedAndIdentified> getEntries() {
        return this.entries;
    }

    public void setPlayersHidden(boolean playersHidden) {
        this.playersHidden = playersHidden;
    }

    public boolean arePlayersHidden() {
        return this.playersHidden;
    }

    @Deprecated
    @NotNull
    public JsonObject build() {
        return ServerListPingType.getModernPingResponse(this, true);
    }

    @Deprecated
    public static class PingPlayer {
        private final String name;
        private final UUID uuid;

        @NotNull
        private static PingPlayer of(@NotNull String name, @NotNull UUID uuid) {
            return new PingPlayer(name, uuid);
        }

        private PingPlayer(@NotNull String name, @NotNull UUID uuid) {
            this.name = name;
            this.uuid = uuid;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public UUID getUuid() {
            return this.uuid;
        }
    }
}

