/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.sound;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.sound.CustomSoundEvent;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;

record BuiltinSoundEvent(NamespaceID namespace, int id) implements StaticProtocolObject,
SoundEvent
{
    private static final Registry.Container<BuiltinSoundEvent> CONTAINER = Registry.createStaticContainer(Registry.Resource.SOUNDS, (namespace, properties) -> new BuiltinSoundEvent(NamespaceID.from(namespace), properties.getInt("id")));
    public static final NetworkBuffer.Type<SoundEvent> NETWORK_TYPE = new NetworkBuffer.Type<SoundEvent>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, SoundEvent value) {
            SoundEvent soundEvent = value;
            Objects.requireNonNull(soundEvent);
            SoundEvent soundEvent2 = soundEvent;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BuiltinSoundEvent.class, CustomSoundEvent.class}, (Object)soundEvent2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    BuiltinSoundEvent soundEvent3 = (BuiltinSoundEvent)soundEvent2;
                    buffer.write(NetworkBuffer.VAR_INT, soundEvent3.id + 1);
                    break;
                }
                case 1: {
                    CustomSoundEvent soundEvent4 = (CustomSoundEvent)soundEvent2;
                    buffer.write(NetworkBuffer.VAR_INT, 0);
                    buffer.write(NetworkBuffer.STRING, soundEvent4.name());
                    buffer.writeOptional(NetworkBuffer.FLOAT, soundEvent4.range());
                }
            }
        }

        @Override
        public SoundEvent read(@NotNull NetworkBuffer buffer) {
            int id = buffer.read(NetworkBuffer.VAR_INT) - 1;
            if (id != -1) {
                return BuiltinSoundEvent.getId(id);
            }
            NamespaceID namespace = NamespaceID.from(buffer.read(NetworkBuffer.STRING));
            return new CustomSoundEvent(namespace, buffer.readOptional(NetworkBuffer.FLOAT));
        }
    };

    static SoundEvent get(@NotNull String namespace) {
        return CONTAINER.get(namespace);
    }

    static SoundEvent getSafe(@NotNull String namespace) {
        return CONTAINER.getSafe(namespace);
    }

    static SoundEvent getId(int id) {
        return CONTAINER.getId(id);
    }

    static Collection<? extends SoundEvent> values() {
        return CONTAINER.values();
    }

    @Override
    public String toString() {
        return this.name();
    }
}

