/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.sound;

import java.util.Collection;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.sound.BuiltinSoundEvent;
import net.minestom.server.sound.CustomSoundEvent;
import net.minestom.server.sound.SoundEvents;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface SoundEvent
extends ProtocolObject,
Sound.Type,
SoundEvents
permits BuiltinSoundEvent, CustomSoundEvent {
    @NotNull
    public static final NetworkBuffer.Type<SoundEvent> NETWORK_TYPE = NetworkBuffer.lazy(() -> BuiltinSoundEvent.NETWORK_TYPE);

    @NotNull
    public static Collection<? extends SoundEvent> values() {
        return BuiltinSoundEvent.values();
    }

    @Nullable
    public static SoundEvent fromNamespaceId(@NotNull String namespaceID) {
        return BuiltinSoundEvent.getSafe(namespaceID);
    }

    @Nullable
    public static SoundEvent fromNamespaceId(@NotNull NamespaceID namespaceID) {
        return SoundEvent.fromNamespaceId(namespaceID.asString());
    }

    @Nullable
    public static SoundEvent fromId(int id) {
        return BuiltinSoundEvent.getId(id);
    }

    @NotNull
    public static SoundEvent of(@NotNull String namespaceID, @Nullable Float range) {
        return new CustomSoundEvent(NamespaceID.from(namespaceID), range);
    }

    @NotNull
    public static SoundEvent of(@NotNull NamespaceID namespaceID, @Nullable Float range) {
        return new CustomSoundEvent(namespaceID, range);
    }

    @Override
    @NotNull
    default public Key key() {
        return ProtocolObject.super.key();
    }
}

