/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import net.minestom.server.MinecraftServer;
import net.minestom.server.Tickable;
import net.minestom.server.thread.MinestomThread;
import net.minestom.server.thread.ThreadDispatcher;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TickThread
extends MinestomThread {
    private final ReentrantLock lock = new ReentrantLock();
    private volatile boolean stop;
    private CountDownLatch latch;
    private long tickTime;
    private long tickNum = 0L;
    private final List<ThreadDispatcher.Partition> entries = new ArrayList<ThreadDispatcher.Partition>();

    public TickThread(int number) {
        super("Ms-Tick-" + number);
    }

    @Nullable
    public static TickThread current() {
        Thread thread = Thread.currentThread();
        if (thread instanceof TickThread) {
            TickThread current = (TickThread)thread;
            return current;
        }
        return null;
    }

    @Override
    public void run() {
        LockSupport.park(this);
        while (!this.stop) {
            this.lock.lock();
            try {
                this.tick();
            }
            catch (Exception e) {
                MinecraftServer.getExceptionManager().handleException(e);
            }
            this.lock.unlock();
            this.latch.countDown();
            LockSupport.park(this);
        }
    }

    private void tick() {
        ReentrantLock lock = this.lock;
        long tickTime = this.tickTime;
        for (ThreadDispatcher.Partition entry : this.entries) {
            assert (entry.thread() == this);
            List<Tickable> elements = entry.elements();
            if (elements.isEmpty()) continue;
            for (Tickable element : elements) {
                if (lock.hasQueuedThreads()) {
                    lock.unlock();
                    lock.lock();
                }
                try {
                    element.tick(tickTime);
                }
                catch (Throwable e) {
                    MinecraftServer.getExceptionManager().handleException(e);
                }
            }
        }
    }

    void startTick(CountDownLatch latch, long tickTime) {
        if (this.entries.isEmpty()) {
            latch.countDown();
            return;
        }
        this.latch = latch;
        this.tickTime = tickTime;
        ++this.tickNum;
        this.stop = false;
        LockSupport.unpark(this);
    }

    public Collection<ThreadDispatcher.Partition> entries() {
        return this.entries;
    }

    @NotNull
    public ReentrantLock lock() {
        return this.lock;
    }

    public long getTick() {
        return this.tickNum;
    }

    void shutdown() {
        this.stop = true;
        LockSupport.unpark(this);
    }
}

