/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public final class NamespaceID
implements CharSequence,
Key {
    private static final String legalLetters = "[0123456789abcdefghijklmnopqrstuvwxyz_-]+";
    private static final String legalPathLetters = "[0123456789abcdefghijklmnopqrstuvwxyz./_-]+";
    private static final Cache<String, NamespaceID> CACHE = Caffeine.newBuilder().weakKeys().weakValues().build();
    private final String domain;
    private final String path;
    private final String full;

    @NotNull
    public static NamespaceID from(@NotNull String namespace) {
        return (NamespaceID)CACHE.get((Object)namespace, id -> {
            String path;
            String domain;
            int index = ((String)id).indexOf(58);
            if (index < 0) {
                domain = "minecraft";
                path = id;
                id = "minecraft:" + (String)id;
            } else {
                domain = ((String)id).substring(0, index);
                path = ((String)id).substring(index + 1);
            }
            return new NamespaceID((String)id, domain, path);
        });
    }

    @NotNull
    public static NamespaceID from(@NotNull String domain, @NotNull String path) {
        return NamespaceID.from(domain + ":" + path);
    }

    @NotNull
    public static NamespaceID from(@NotNull Key key) {
        return NamespaceID.from(key.asString());
    }

    private NamespaceID(String full, String domain, String path) {
        this.full = full;
        this.domain = domain;
        this.path = path;
        assert (!domain.contains(".") && !domain.contains("/")) : "Domain cannot contain a dot nor a slash character (" + full + ")";
        assert (domain.matches(legalLetters)) : "Illegal character in domain (" + full + "). Must match [0123456789abcdefghijklmnopqrstuvwxyz_-]+";
        assert (path.matches(legalPathLetters)) : "Illegal character in path (" + full + "). Must match [0123456789abcdefghijklmnopqrstuvwxyz./_-]+";
    }

    @NotNull
    public String domain() {
        return this.domain;
    }

    @NotNull
    public String path() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key that = (Key)o;
        return Objects.equals(this.domain, that.namespace()) && Objects.equals(this.path, that.value());
    }

    public int hashCode() {
        int result = this.domain.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    @Override
    public int length() {
        return this.full.length();
    }

    @Override
    public char charAt(int index) {
        return this.full.charAt(index);
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.full.subSequence(start, end);
    }

    @Override
    @NotNull
    public String toString() {
        return this.full;
    }

    @Pattern(value="[a-z0-9_\\-.]+")
    @NotNull
    public String namespace() {
        return this.domain;
    }

    @NotNull
    public String value() {
        return this.path;
    }

    @NotNull
    public String asString() {
        return this.full;
    }

    @Deprecated
    public String getDomain() {
        return this.domain();
    }

    @Deprecated
    public String getPath() {
        return this.path();
    }
}

