/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.chunk;

import java.util.Arrays;
import net.minestom.server.instance.Chunk;
import net.minestom.server.utils.chunk.ChunkUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ChunkUpdateLimitChecker {
    private final int historySize;
    private final long[] chunkHistory;

    public ChunkUpdateLimitChecker(int historySize) {
        this.historySize = historySize;
        this.chunkHistory = new long[historySize];
        this.clearHistory();
    }

    public boolean addToHistory(Chunk chunk) {
        long index = ChunkUtils.getChunkIndex(chunk);
        boolean result = true;
        int lastIndex = this.historySize - 1;
        for (int i = 0; i < lastIndex; ++i) {
            if (this.chunkHistory[i] == index) {
                result = false;
            }
            this.chunkHistory[i] = this.chunkHistory[i + 1];
        }
        this.chunkHistory[lastIndex] = index;
        return result;
    }

    public void clearHistory() {
        Arrays.fill(this.chunkHistory, Long.MAX_VALUE);
    }
}

