/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.chunk;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.utils.function.IntegerBiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ChunkUtils {
    private ChunkUtils() {
    }

    @NotNull
    public static CompletableFuture<Void> optionalLoadAll(@NotNull Instance instance, long @NotNull [] chunks, @Nullable Consumer<Chunk> eachCallback) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        AtomicInteger counter = new AtomicInteger(0);
        for (long visibleChunk : chunks) {
            instance.loadOptionalChunk(ChunkUtils.getChunkCoordX(visibleChunk), ChunkUtils.getChunkCoordZ(visibleChunk)).thenAccept(chunk -> {
                if (eachCallback != null) {
                    eachCallback.accept((Chunk)chunk);
                }
                if (counter.incrementAndGet() == chunks.length) {
                    completableFuture.complete(null);
                }
            });
        }
        return completableFuture;
    }

    public static boolean isLoaded(@Nullable Chunk chunk) {
        return chunk != null && chunk.isLoaded();
    }

    public static boolean isLoaded(@NotNull Instance instance, double x, double z) {
        Chunk chunk = instance.getChunk(ChunkUtils.getChunkCoordinate(x), ChunkUtils.getChunkCoordinate(z));
        return ChunkUtils.isLoaded(chunk);
    }

    public static boolean isLoaded(@NotNull Instance instance, @NotNull Point point) {
        Chunk chunk = instance.getChunk(point.chunkX(), point.chunkZ());
        return ChunkUtils.isLoaded(chunk);
    }

    public static Chunk retrieve(Instance instance, Chunk originChunk, double x, double z) {
        int chunkX = ChunkUtils.getChunkCoordinate(x);
        int chunkZ = ChunkUtils.getChunkCoordinate(z);
        boolean sameChunk = originChunk != null && originChunk.getChunkX() == chunkX && originChunk.getChunkZ() == chunkZ;
        return sameChunk ? originChunk : instance.getChunk(chunkX, chunkZ);
    }

    public static Chunk retrieve(Instance instance, Chunk originChunk, Point position) {
        return ChunkUtils.retrieve(instance, originChunk, position.x(), position.z());
    }

    public static int getChunkCoordinate(double xz) {
        return ChunkUtils.getChunkCoordinate((int)Math.floor(xz));
    }

    public static int getChunkCoordinate(int xz) {
        return xz >> 4;
    }

    public static long getChunkIndex(int chunkX, int chunkZ) {
        return (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
    }

    public static long getChunkIndex(@NotNull Chunk chunk) {
        return ChunkUtils.getChunkIndex(chunk.getChunkX(), chunk.getChunkZ());
    }

    public static long getChunkIndex(@NotNull Point point) {
        return ChunkUtils.getChunkIndex(point.chunkX(), point.chunkZ());
    }

    public static int getChunkCoordX(long index) {
        return (int)(index >> 32);
    }

    public static int getChunkCoordZ(long index) {
        return (int)index;
    }

    public static int getChunkCount(int range) {
        if (range < 0) {
            throw new IllegalArgumentException("Range cannot be negative");
        }
        int square = range * 2 + 1;
        return square * square;
    }

    public static void forDifferingChunksInRange(int newChunkX, int newChunkZ, int oldChunkX, int oldChunkZ, int range, @NotNull IntegerBiConsumer callback) {
        for (int x = newChunkX - range; x <= newChunkX + range; ++x) {
            for (int z = newChunkZ - range; z <= newChunkZ + range; ++z) {
                if (Math.abs(x - oldChunkX) <= range && Math.abs(z - oldChunkZ) <= range) continue;
                callback.accept(x, z);
            }
        }
    }

    public static void forDifferingChunksInRange(int newChunkX, int newChunkZ, int oldChunkX, int oldChunkZ, int range, @NotNull IntegerBiConsumer newCallback, @NotNull IntegerBiConsumer oldCallback) {
        ChunkUtils.forDifferingChunksInRange(newChunkX, newChunkZ, oldChunkX, oldChunkZ, range, newCallback);
        ChunkUtils.forDifferingChunksInRange(oldChunkX, oldChunkZ, newChunkX, newChunkZ, range, oldCallback);
    }

    public static void forChunksInRange(int chunkX, int chunkZ, int range, IntegerBiConsumer consumer) {
        consumer.accept(chunkX, chunkZ);
        block6: for (int id = 1; id < (range * 2 + 1) * (range * 2 + 1); ++id) {
            int index = id - 1;
            int radius = (int)Math.floor((Math.sqrt((double)index + 1.0) - 1.0) / 2.0) + 1;
            int p = 8 * radius * (radius - 1) / 2;
            int en = radius * 2;
            int a = (1 + index - p) % (radius * 8);
            switch (a / (radius * 2)) {
                case 0: {
                    consumer.accept(a - radius + chunkX, -radius + chunkZ);
                    continue block6;
                }
                case 1: {
                    consumer.accept(radius + chunkX, a % en - radius + chunkZ);
                    continue block6;
                }
                case 2: {
                    consumer.accept(radius - a % en + chunkX, radius + chunkZ);
                    continue block6;
                }
                case 3: {
                    consumer.accept(-radius + chunkX, radius - a % en + chunkZ);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("unreachable");
                }
            }
        }
    }

    public static void forChunksInRange(@NotNull Point point, int range, IntegerBiConsumer consumer) {
        ChunkUtils.forChunksInRange(point.chunkX(), point.chunkZ(), range, consumer);
    }

    public static int getBlockIndex(int x, int y, int z) {
        z %= 16;
        int index = (x %= 16) & 0xF;
        if (y > 0) {
            index |= y << 4 & 0x7FFFFF0;
        } else {
            index |= -y << 4 & 0x7FFFFF0;
            index |= 0x8000000;
        }
        return index |= z << 28 & 0xF0000000;
    }

    @NotNull
    public static Point getBlockPosition(int index, int chunkX, int chunkZ) {
        int x = ChunkUtils.blockIndexToChunkPositionX(index) + 16 * chunkX;
        int y = ChunkUtils.blockIndexToChunkPositionY(index);
        int z = ChunkUtils.blockIndexToChunkPositionZ(index) + 16 * chunkZ;
        return new Vec(x, y, z);
    }

    public static int blockIndexToChunkPositionX(int index) {
        return index & 0xF;
    }

    public static int blockIndexToChunkPositionY(int index) {
        int y = (index & 0x7FFFFF0) >>> 4;
        if ((index >>> 27 & 1) == 1) {
            y = -y;
        }
        return y;
    }

    public static int blockIndexToChunkPositionZ(int index) {
        return index >> 28 & 0xF;
    }

    public static int toSectionRelativeCoordinate(int xyz) {
        return xyz & 0xF;
    }

    public static int toRegionCoordinate(int chunkCoordinate) {
        return chunkCoordinate >> 5;
    }

    public static int toRegionLocal(int chunkCoordinate) {
        return chunkCoordinate & 0x1F;
    }

    public static int floorSection(int coordinate) {
        return coordinate - (coordinate & 0xF);
    }

    public static int ceilSection(int coordinate) {
        return (coordinate - 1 | 0xF) + 1;
    }
}

