/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.inventory;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.click.Click;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.client.play.ClientClickWindowPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClickUtils {
    @NotNull
    public static Click.Getter makeGetter(@NotNull Inventory inventory, @NotNull PlayerInventory playerInventory) {
        return new Click.Getter(inventory::getItemStack, x$0 -> playerInventory.getItemStack(x$0), playerInventory.getCursorItem(), inventory.getSize());
    }

    public static boolean conservative(@NotNull List<Click.Change> clientDefault, @NotNull Inventory inventory, @NotNull PlayerInventory playerInventory) {
        Click.Getter getter = ClickUtils.makeGetter(inventory, playerInventory);
        return ClickUtils.consolidate(clientDefault, getter.mainSize()).conservative(getter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<Click.Change> packetToChanges(@NotNull ClientClickWindowPacket packet, @NotNull Click.Info info, @NotNull Click.Getter getter, boolean playerInventory) {
        ArrayList<Click.Change> changes = new ArrayList<Click.Change>();
        for (ClientClickWindowPacket.ChangedSlot change : packet.changedSlots()) {
            int slot = change.slot();
            if (playerInventory) {
                slot = PlayerInventoryUtils.protocolToMinestom(slot);
            }
            changes.add(new Click.Change.Container(slot, change.item()));
        }
        changes.add(new Click.Change.Cursor(packet.clickedItem()));
        if (info instanceof Click.Info.OffhandSwap) {
            Click.Info.OffhandSwap swap = (Click.Info.OffhandSwap)info;
            if (!playerInventory) {
                changes.add(new Click.Change.Player(45, getter.get(swap.slot())));
            }
        }
        Click.Info info2 = info;
        Objects.requireNonNull(info2);
        Click.Info info3 = info2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Click.Info.LeftDropCursor.class, Click.Info.RightDropCursor.class, Click.Info.DropSlot.class, Click.Info.CreativeDropItem.class}, (Object)info3, n)) {
            case 0: {
                Click.Info.LeftDropCursor leftDropCursor = (Click.Info.LeftDropCursor)info3;
                changes.add(new Click.Change.DropFromPlayer(getter.cursor()));
                return changes;
            }
            case 1: {
                Click.Info.RightDropCursor rightDropCursor = (Click.Info.RightDropCursor)info3;
                changes.add(new Click.Change.DropFromPlayer(getter.cursor().withAmount(1)));
                return changes;
            }
            case 2: {
                Click.Info.DropSlot dropSlot = (Click.Info.DropSlot)info3;
                try {
                    int n2;
                    int slot = n2 = dropSlot.slot();
                    int all = n2 = (int)(dropSlot.all() ? 1 : 0);
                    changes.add(new Click.Change.DropFromPlayer(all != 0 ? getter.get(slot) : getter.get(slot).withAmount(1)));
                    return changes;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 3: {
                Click.Info.CreativeDropItem creativeDropItem = (Click.Info.CreativeDropItem)info3;
                {
                    ItemStack itemStack;
                    ItemStack item = itemStack = creativeDropItem.item();
                    changes.add(new Click.Change.DropFromPlayer(item));
                }
                return changes;
            }
        }
        return changes;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static FlatChanges consolidate(@NotNull List<Click.Change> changes, int size) {
        HashMap<Integer, ItemStack> container = new HashMap<Integer, ItemStack>();
        HashMap<Integer, ItemStack> player = new HashMap<Integer, ItemStack>();
        Object cursor = null;
        ArrayList<ItemStack> dropped = new ArrayList<ItemStack>();
        Iterator<Click.Change> iterator = changes.iterator();
        block11: while (iterator.hasNext()) {
            Object object;
            Object item;
            int slot;
            Click.Change change;
            Click.Change change2 = iterator.next();
            Objects.requireNonNull(change2);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Click.Change.Container.class, Click.Change.Player.class, Click.Change.Cursor.class, Click.Change.DropFromPlayer.class}, (Object)change, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Object object2;
                    Click.Change.Container container2 = (Click.Change.Container)change;
                    try {
                        int n2;
                        slot = n2 = container2.slot();
                        item = object2 = container2.item();
                        if (slot < size) {
                            container.put(slot, (ItemStack)item);
                            continue block11;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                player.put(PlayerInventoryUtils.protocolToMinestom(slot, size), (ItemStack)item);
                continue block11;
                case 1: {
                    Object object3;
                    Object object2 = (Click.Change.Player)change;
                    {
                        int n3;
                        int slot2 = n3 = ((Click.Change.Player)object2).slot();
                        Object item2 = object3 = ((Click.Change.Player)object2).item();
                        player.put(slot2, (ItemStack)item2);
                    }
                    continue block11;
                }
                case 2: {
                    Object object3 = (Click.Change.Cursor)change;
                    {
                        Object item3;
                        cursor = item3 = (object = ((Click.Change.Cursor)object3).item());
                        continue block11;
                    }
                }
                case 3: 
            }
            object = (Click.Change.DropFromPlayer)change;
            {
                ItemStack itemStack;
                ItemStack item4 = itemStack = ((Click.Change.DropFromPlayer)object).item();
                dropped.add(item4);
            }
        }
        return new FlatChanges((Map<Integer, ItemStack>)container, (Map<Integer, ItemStack>)player, (ItemStack)cursor, (List<ItemStack>)dropped);
    }

    public record FlatChanges(@NotNull Map<Integer, ItemStack> container, @NotNull Map<Integer, ItemStack> player, @Nullable ItemStack cursor, @NotNull List<ItemStack> dropped) {
        public boolean conservative(@NotNull Click.Getter getter) {
            Object2IntOpenHashMap items = new Object2IntOpenHashMap();
            items.defaultReturnValue(0);
            BiConsumer<ItemStack, Integer> updater = (arg_0, arg_1) -> FlatChanges.lambda$conservative$0((Object2IntMap)items, arg_0, arg_1);
            this.container.values().forEach(item -> updater.accept((ItemStack)item, item.amount()));
            this.player.values().forEach(item -> updater.accept((ItemStack)item, item.amount()));
            this.dropped.forEach(item -> updater.accept((ItemStack)item, item.amount()));
            this.container.keySet().stream().map(getter.main()::apply).forEach(item -> updater.accept((ItemStack)item, -item.amount()));
            this.player.keySet().stream().map(getter.player()::apply).forEach(item -> updater.accept((ItemStack)item, -item.amount()));
            if (this.cursor != null) {
                updater.accept(this.cursor, this.cursor.amount());
                updater.accept(getter.cursor(), -getter.cursor().amount());
            }
            return items.values().intStream().allMatch(i -> i == 0);
        }

        private static /* synthetic */ void lambda$conservative$0(Object2IntMap items, ItemStack item, Integer count) {
            if (item.isAir()) {
                return;
            }
            ItemStack one = item.withAmount(1);
            items.put((Object)one, items.getInt((Object)one) + count);
        }
    }
}

