/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.inventory;

import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public final class PlayerInventoryUtils {
    public static final int INVENTORY_SIZE = 46;
    public static final int INNER_SIZE = 36;
    public static final int PROTOCOL_OFFSET = 9;
    public static final int CRAFT_RESULT = 36;
    public static final int CRAFT_SLOT_1 = 37;
    public static final int CRAFT_SLOT_2 = 38;
    public static final int CRAFT_SLOT_3 = 39;
    public static final int CRAFT_SLOT_4 = 40;
    public static final int HELMET_SLOT = 41;
    public static final int CHESTPLATE_SLOT = 42;
    public static final int LEGGINGS_SLOT = 43;
    public static final int BOOTS_SLOT = 44;
    public static final int OFF_HAND_SLOT = 45;

    @NotNull
    public static IntStream getInnerShiftClickSlots(int size) {
        return IntStream.range(0, 36).map(i -> i + size);
    }

    @NotNull
    public static IntStream getInnerDoubleClickSlots(int size) {
        return IntStream.range(0, 36).map(i -> i + size);
    }

    private PlayerInventoryUtils() {
    }

    public static int minestomToProtocol(int slot) {
        return switch (slot) {
            case 36 -> 0;
            case 37 -> 1;
            case 38 -> 2;
            case 39 -> 3;
            case 40 -> 4;
            case 41 -> 5;
            case 42 -> 6;
            case 43 -> 7;
            case 44 -> 8;
            case 45 -> 45;
            default -> slot >= 0 && slot <= 8 ? slot + 36 : (slot >= 9 && slot <= 35 ? slot : -1);
        };
    }

    public static int protocolToMinestom(int slot) {
        return switch (slot) {
            case 0 -> 36;
            case 1 -> 37;
            case 2 -> 38;
            case 3 -> 39;
            case 4 -> 40;
            case 5 -> 41;
            case 6 -> 42;
            case 7 -> 43;
            case 8 -> 44;
            case 45 -> 45;
            default -> slot >= 36 && slot <= 44 ? slot - 36 : (slot >= 9 && slot <= 35 ? slot : -1);
        };
    }

    public static int minestomToProtocol(int slot, int openInventorySize) {
        return PlayerInventoryUtils.minestomToProtocol(slot) + openInventorySize - 9;
    }

    public static int protocolToMinestom(int slot, int openInventorySize) {
        if (slot < openInventorySize) {
            return -1;
        }
        return PlayerInventoryUtils.protocolToMinestom(slot - openInventorySize + 9);
    }
}

