/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.nbt;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.NumberBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.nbt.TagStringIOExt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minestom.server.item.ItemStack;
import net.minestom.server.utils.UniqueIdUtils;
import net.minestom.server.utils.Unit;
import org.jetbrains.annotations.NotNull;

public interface BinaryTagSerializer<T> {
    public static final BinaryTagSerializer<Unit> UNIT = new BinaryTagSerializer<Unit>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Unit value) {
            return EndBinaryTag.endBinaryTag();
        }

        @Override
        @NotNull
        public Unit read(@NotNull BinaryTag tag) {
            return Unit.INSTANCE;
        }
    };
    public static final BinaryTagSerializer<Byte> BYTE = new BinaryTagSerializer<Byte>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Byte value) {
            return ByteBinaryTag.byteBinaryTag((byte)value);
        }

        @Override
        @NotNull
        public Byte read(@NotNull BinaryTag tag) {
            Byte by;
            if (tag instanceof ByteBinaryTag) {
                ByteBinaryTag byteBinaryTag = (ByteBinaryTag)tag;
                by = byteBinaryTag.value();
            } else {
                by = 0;
            }
            return by;
        }
    };
    public static final BinaryTagSerializer<Boolean> BOOLEAN = BYTE.map(b -> b != 0, b -> (byte)(b != false ? 1 : 0));
    public static final BinaryTagSerializer<Integer> INT = new BinaryTagSerializer<Integer>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull Integer value) {
            return IntBinaryTag.intBinaryTag((int)value);
        }

        @Override
        @NotNull
        public Integer read(@NotNull BinaryTag tag) {
            Integer n;
            if (tag instanceof NumberBinaryTag) {
                NumberBinaryTag numberTag = (NumberBinaryTag)tag;
                n = numberTag.intValue();
            } else {
                n = 0;
            }
            return n;
        }
    };
    public static final BinaryTagSerializer<String> STRING = new BinaryTagSerializer<String>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull String value) {
            return StringBinaryTag.stringBinaryTag((String)value);
        }

        @Override
        @NotNull
        public String read(@NotNull BinaryTag tag) {
            String string;
            if (tag instanceof StringBinaryTag) {
                StringBinaryTag stringBinaryTag = (StringBinaryTag)tag;
                string = stringBinaryTag.value();
            } else {
                string = "";
            }
            return string;
        }
    };
    public static final BinaryTagSerializer<CompoundBinaryTag> COMPOUND = new BinaryTagSerializer<CompoundBinaryTag>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull CompoundBinaryTag value) {
            return value;
        }

        @Override
        @NotNull
        public CompoundBinaryTag read(@NotNull BinaryTag tag) {
            CompoundBinaryTag compoundBinaryTag;
            return tag instanceof CompoundBinaryTag ? (compoundBinaryTag = (CompoundBinaryTag)tag) : CompoundBinaryTag.empty();
        }
    };
    public static final BinaryTagSerializer<CompoundBinaryTag> COMPOUND_COERCED = BinaryTagSerializer.coerced(BinaryTagTypes.COMPOUND);
    public static final BinaryTagSerializer<Component> JSON_COMPONENT = STRING.map(s -> GsonComponentSerializer.gson().deserialize(s), c -> (String)GsonComponentSerializer.gson().serialize(c));
    public static final BinaryTagSerializer<ItemStack> ITEM = COMPOUND.map(ItemStack::fromItemNBT, ItemStack::toItemNBT);
    public static final BinaryTagSerializer<UUID> UUID = new BinaryTagSerializer<UUID>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull UUID value) {
            return UniqueIdUtils.toNbt(value);
        }

        @Override
        public @NotNull UUID read(@NotNull BinaryTag tag) {
            if (!(tag instanceof IntArrayBinaryTag)) {
                throw new IllegalArgumentException("unexpected uuid type: " + String.valueOf(tag.type()));
            }
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return UniqueIdUtils.fromNbt(intArrayTag);
        }
    };

    @NotNull
    public static <T> BinaryTagSerializer<T> recursive(final @NotNull Function<BinaryTagSerializer<T>, BinaryTagSerializer<T>> self) {
        return new BinaryTagSerializer<T>(){
            private BinaryTagSerializer<T> serializer = null;

            @Override
            @NotNull
            public BinaryTag write(@NotNull T value) {
                return this.serializer().write(value);
            }

            @Override
            @NotNull
            public T read(@NotNull BinaryTag tag) {
                return this.serializer().read(tag);
            }

            private BinaryTagSerializer<T> serializer() {
                if (this.serializer == null) {
                    this.serializer = (BinaryTagSerializer)self.apply(this);
                }
                return this.serializer;
            }
        };
    }

    @NotNull
    public static <T> BinaryTagSerializer<T> lazy(final @NotNull Supplier<BinaryTagSerializer<T>> self) {
        return new BinaryTagSerializer<T>(){
            private BinaryTagSerializer<T> serializer = null;

            @Override
            @NotNull
            public BinaryTag write(@NotNull T value) {
                return this.serializer().write(value);
            }

            @Override
            @NotNull
            public T read(@NotNull BinaryTag tag) {
                return this.serializer().read(tag);
            }

            private BinaryTagSerializer<T> serializer() {
                if (this.serializer == null) {
                    this.serializer = (BinaryTagSerializer)self.get();
                }
                return this.serializer;
            }
        };
    }

    @NotNull
    public static <T extends BinaryTag> BinaryTagSerializer<T> coerced(final @NotNull BinaryTagType<T> type) {
        return new BinaryTagSerializer<T>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull T value) {
                return value;
            }

            @Override
            @NotNull
            public T read(@NotNull BinaryTag tag) {
                if (tag.type() == type) {
                    return tag;
                }
                if (tag instanceof StringBinaryTag) {
                    StringBinaryTag string = (StringBinaryTag)tag;
                    try {
                        tag = TagStringIOExt.readTag(string.value());
                        if (tag.type() == type) {
                            return tag;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new IllegalArgumentException("Expected " + String.valueOf(type) + " but got " + String.valueOf(tag));
            }
        };
    }

    @NotNull
    public static <E extends Enum<E>> BinaryTagSerializer<E> fromEnumStringable(@NotNull Class<E> enumClass) {
        final Enum[] values = (Enum[])enumClass.getEnumConstants();
        final Map nameMap = Arrays.stream(values).collect(Collectors.toMap(e -> e.name().toLowerCase(Locale.ROOT), Function.identity()));
        return new BinaryTagSerializer<E>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull E value) {
                return StringBinaryTag.stringBinaryTag((String)((Enum)value).name().toLowerCase(Locale.ROOT));
            }

            @Override
            @NotNull
            public E read(@NotNull BinaryTag tag) {
                BinaryTag binaryTag = tag;
                Objects.requireNonNull(binaryTag);
                BinaryTag binaryTag2 = binaryTag;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntBinaryTag.class, StringBinaryTag.class}, (Object)binaryTag2, n)) {
                    case 0 -> {
                        IntBinaryTag intBinaryTag = (IntBinaryTag)binaryTag2;
                        yield values[intBinaryTag.value()];
                    }
                    case 1 -> {
                        StringBinaryTag string = (StringBinaryTag)binaryTag2;
                        yield nameMap.getOrDefault(string.value().toLowerCase(Locale.ROOT), values[0]);
                    }
                    default -> values[0];
                };
            }
        };
    }

    @NotNull
    public BinaryTag write(@NotNull T var1);

    @NotNull
    public T read(@NotNull BinaryTag var1);

    default public <S> BinaryTagSerializer<S> map(final @NotNull Function<T, S> to, final @NotNull Function<S, T> from) {
        return new BinaryTagSerializer<S>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull S value) {
                return BinaryTagSerializer.this.write(from.apply(value));
            }

            @Override
            @NotNull
            public S read(@NotNull BinaryTag tag) {
                return to.apply(BinaryTagSerializer.this.read(tag));
            }
        };
    }

    default public BinaryTagSerializer<List<T>> list() {
        return new BinaryTagSerializer<List<T>>(){

            @Override
            @NotNull
            public BinaryTag write(@NotNull List<T> value) {
                ListBinaryTag.Builder builder = ListBinaryTag.builder();
                for (Object t : value) {
                    builder.add(BinaryTagSerializer.this.write(t));
                }
                return builder.build();
            }

            @Override
            @NotNull
            public List<T> read(@NotNull BinaryTag tag) {
                if (!(tag instanceof ListBinaryTag)) {
                    return List.of();
                }
                ListBinaryTag listBinaryTag = (ListBinaryTag)tag;
                ArrayList list = new ArrayList();
                for (BinaryTag element : listBinaryTag) {
                    list.add(BinaryTagSerializer.this.read(element));
                }
                return List.copyOf(list);
            }
        };
    }
}

