/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.network.packet.server.configuration.RegistryDataPacket;
import net.minestom.server.utils.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionType {
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    private static final int VANILLA_MIN_Y = -64;
    private static final int VANILLA_MAX_Y = 319;
    public static final DimensionType OVERWORLD = DimensionType.builder(NamespaceID.from("minecraft:overworld")).ultrawarm(false).natural(true).piglinSafe(false).respawnAnchorSafe(false).bedSafe(true).raidCapable(true).skylightEnabled(true).ceilingEnabled(false).fixedTime(null).ambientLight(0.0f).height(384).minY(-64).logicalHeight(384).infiniburn(NamespaceID.from("minecraft:infiniburn_overworld")).build();
    private final int id = idCounter.getAndIncrement();
    protected volatile boolean registered;
    private final NamespaceID name;
    private final boolean natural;
    private final float ambientLight;
    private final boolean ceilingEnabled;
    private final boolean skylightEnabled;
    @Nullable
    private final Long fixedTime;
    private final boolean raidCapable;
    private final boolean respawnAnchorSafe;
    private final boolean ultrawarm;
    private final boolean bedSafe;
    private final String effects;
    private final boolean piglinSafe;
    private final int minY;
    private final int height;
    private final int logicalHeight;
    private final double coordinateScale;
    private final NamespaceID infiniburn;

    DimensionType(NamespaceID name, boolean natural, float ambientLight, boolean ceilingEnabled, boolean skylightEnabled, @Nullable Long fixedTime, boolean raidCapable, boolean respawnAnchorSafe, boolean ultrawarm, boolean bedSafe, String effects, boolean piglinSafe, int minY, int height, int logicalHeight, double coordinateScale, NamespaceID infiniburn) {
        this.name = name;
        this.natural = natural;
        this.ambientLight = ambientLight;
        this.ceilingEnabled = ceilingEnabled;
        this.skylightEnabled = skylightEnabled;
        this.fixedTime = fixedTime;
        this.raidCapable = raidCapable;
        this.respawnAnchorSafe = respawnAnchorSafe;
        this.ultrawarm = ultrawarm;
        this.bedSafe = bedSafe;
        this.effects = effects;
        this.piglinSafe = piglinSafe;
        this.minY = minY;
        this.height = height;
        this.logicalHeight = logicalHeight;
        this.coordinateScale = coordinateScale;
        this.infiniburn = infiniburn;
    }

    public static DimensionTypeBuilder builder(NamespaceID name) {
        return DimensionType.hiddenBuilder().name(name);
    }

    public static DimensionTypeBuilder hiddenBuilder() {
        return new DimensionTypeBuilder();
    }

    public static DimensionType fromNBT(CompoundBinaryTag nbt) {
        return DimensionType.builder(NamespaceID.from(nbt.getString("name"))).ambientLight(nbt.getFloat("ambient_light")).infiniburn(NamespaceID.from(nbt.getString("infiniburn").replaceFirst("#", ""))).natural(nbt.getBoolean("natural")).ceilingEnabled(nbt.getBoolean("has_ceiling")).skylightEnabled(nbt.getBoolean("has_skylight")).ultrawarm(nbt.getBoolean("ultrawarm")).raidCapable(nbt.getBoolean("has_raids")).respawnAnchorSafe(nbt.getBoolean("respawn_anchor_works")).bedSafe(nbt.getBoolean("bed_works")).effects(nbt.getString("effects")).piglinSafe(nbt.getBoolean("piglin_safe")).logicalHeight(nbt.getInt("logical_height")).coordinateScale(nbt.getDouble("coordinate_scale")).build();
    }

    @NotNull
    public RegistryDataPacket.Entry toRegistryEntry() {
        return new RegistryDataPacket.Entry(this.name.toString(), this.toNBT());
    }

    @NotNull
    public CompoundBinaryTag toNBT() {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        builder.putFloat("ambient_light", this.ambientLight);
        builder.putString("infiniburn", "#" + this.infiniburn.toString());
        builder.putByte("natural", (byte)(this.natural ? 1 : 0));
        builder.putByte("has_ceiling", (byte)(this.ceilingEnabled ? 1 : 0));
        builder.putByte("has_skylight", (byte)(this.skylightEnabled ? 1 : 0));
        builder.putByte("ultrawarm", (byte)(this.ultrawarm ? 1 : 0));
        builder.putByte("has_raids", (byte)(this.raidCapable ? 1 : 0));
        builder.putByte("respawn_anchor_works", (byte)(this.respawnAnchorSafe ? 1 : 0));
        builder.putByte("bed_works", (byte)(this.bedSafe ? 1 : 0));
        builder.putString("effects", this.effects);
        builder.putByte("piglin_safe", (byte)(this.piglinSafe ? 1 : 0));
        builder.putInt("min_y", this.minY);
        builder.putInt("height", this.height);
        builder.putInt("logical_height", this.logicalHeight);
        builder.putDouble("coordinate_scale", this.coordinateScale);
        builder.putString("name", this.name.toString());
        builder.putInt("monster_spawn_block_light_limit", 0);
        builder.putInt("monster_spawn_light_level", 11);
        if (this.fixedTime != null) {
            builder.putLong("fixed_time", this.fixedTime.longValue());
        }
        return builder.build();
    }

    public String toString() {
        return this.name.toString();
    }

    public int getId() {
        return this.id;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public NamespaceID getName() {
        return this.name;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public float getAmbientLight() {
        return this.ambientLight;
    }

    public boolean isCeilingEnabled() {
        return this.ceilingEnabled;
    }

    public boolean isSkylightEnabled() {
        return this.skylightEnabled;
    }

    @Nullable
    public Long getFixedTime() {
        return this.fixedTime;
    }

    public boolean isRaidCapable() {
        return this.raidCapable;
    }

    public boolean isRespawnAnchorSafe() {
        return this.respawnAnchorSafe;
    }

    public boolean isUltrawarm() {
        return this.ultrawarm;
    }

    public boolean isBedSafe() {
        return this.bedSafe;
    }

    public String getEffects() {
        return this.effects;
    }

    public boolean isPiglinSafe() {
        return this.piglinSafe;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxY() {
        return this.getMinY() + this.getHeight();
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    public double getCoordinateScale() {
        return this.coordinateScale;
    }

    public NamespaceID getInfiniburn() {
        return this.infiniburn;
    }

    public int getTotalHeight() {
        return this.minY + this.height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionType that = (DimensionType)o;
        return this.id == that.id && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public static class DimensionTypeBuilder {
        private NamespaceID name;
        private boolean natural;
        private float ambientLight;
        private boolean ceilingEnabled;
        private boolean skylightEnabled;
        @Nullable
        private Long fixedTime = null;
        private boolean raidCapable;
        private boolean respawnAnchorSafe;
        private boolean ultrawarm;
        private boolean bedSafe = true;
        private String effects = "minecraft:overworld";
        private boolean piglinSafe = false;
        private int minY = -64;
        private int logicalHeight = 384;
        private int height = 384;
        private double coordinateScale = 1.0;
        private NamespaceID infiniburn = NamespaceID.from("minecraft:infiniburn_overworld");

        DimensionTypeBuilder() {
        }

        public DimensionTypeBuilder name(NamespaceID name) {
            this.name = name;
            return this;
        }

        public DimensionTypeBuilder natural(boolean natural) {
            this.natural = natural;
            return this;
        }

        public DimensionTypeBuilder ambientLight(float ambientLight) {
            this.ambientLight = ambientLight;
            return this;
        }

        public DimensionTypeBuilder ceilingEnabled(boolean ceilingEnabled) {
            this.ceilingEnabled = ceilingEnabled;
            return this;
        }

        public DimensionTypeBuilder skylightEnabled(boolean skylightEnabled) {
            this.skylightEnabled = skylightEnabled;
            return this;
        }

        public DimensionTypeBuilder fixedTime(Long fixedTime) {
            this.fixedTime = fixedTime;
            return this;
        }

        public DimensionTypeBuilder raidCapable(boolean raidCapable) {
            this.raidCapable = raidCapable;
            return this;
        }

        public DimensionTypeBuilder respawnAnchorSafe(boolean respawnAnchorSafe) {
            this.respawnAnchorSafe = respawnAnchorSafe;
            return this;
        }

        public DimensionTypeBuilder ultrawarm(boolean ultrawarm) {
            this.ultrawarm = ultrawarm;
            return this;
        }

        public DimensionTypeBuilder bedSafe(boolean bedSafe) {
            this.bedSafe = bedSafe;
            return this;
        }

        public DimensionTypeBuilder effects(String effects) {
            this.effects = effects;
            return this;
        }

        public DimensionTypeBuilder piglinSafe(boolean piglinSafe) {
            this.piglinSafe = piglinSafe;
            return this;
        }

        public DimensionTypeBuilder minY(int minY) {
            this.minY = minY;
            return this;
        }

        public DimensionTypeBuilder height(int height) {
            this.height = height;
            return this;
        }

        public DimensionTypeBuilder logicalHeight(int logicalHeight) {
            this.logicalHeight = logicalHeight;
            return this;
        }

        public DimensionTypeBuilder coordinateScale(double coordinateScale) {
            this.coordinateScale = coordinateScale;
            return this;
        }

        public DimensionTypeBuilder infiniburn(NamespaceID infiniburn) {
            this.infiniburn = infiniburn;
            return this;
        }

        public DimensionType build() {
            return new DimensionType(this.name, this.natural, this.ambientLight, this.ceilingEnabled, this.skylightEnabled, this.fixedTime, this.raidCapable, this.respawnAnchorSafe, this.ultrawarm, this.bedSafe, this.effects, this.piglinSafe, this.minY, this.height, this.logicalHeight, this.coordinateScale, this.infiniburn);
        }
    }
}

