/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.configuration.RegistryDataPacket;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DimensionTypeManager {
    private final CachedPacket registryDataPacket = new CachedPacket(this::createRegistryDataPacket);
    private final List<DimensionType> dimensionTypes = new CopyOnWriteArrayList<DimensionType>();

    public DimensionTypeManager() {
        this.addDimension(DimensionType.OVERWORLD);
    }

    public void addDimension(@NotNull DimensionType dimensionType) {
        dimensionType.registered = true;
        this.dimensionTypes.add(dimensionType);
        this.registryDataPacket.invalidate();
    }

    public boolean removeDimension(@NotNull DimensionType dimensionType) {
        dimensionType.registered = false;
        boolean removed = this.dimensionTypes.remove(dimensionType);
        if (removed) {
            this.registryDataPacket.invalidate();
        }
        return removed;
    }

    public boolean isRegistered(@NotNull NamespaceID namespaceID) {
        return this.isRegistered(this.getDimension(namespaceID));
    }

    public boolean isRegistered(@Nullable DimensionType dimensionType) {
        return dimensionType != null && this.dimensionTypes.contains(dimensionType) && dimensionType.isRegistered();
    }

    @Nullable
    public DimensionType getDimension(@NotNull NamespaceID namespaceID) {
        return this.unmodifiableList().stream().filter(dimensionType -> dimensionType.getName().equals(namespaceID)).filter(DimensionType::isRegistered).findFirst().orElse(null);
    }

    @NotNull
    public List<DimensionType> unmodifiableList() {
        return Collections.unmodifiableList(this.dimensionTypes);
    }

    @NotNull
    public SendablePacket registryDataPacket() {
        return this.registryDataPacket;
    }

    @NotNull
    private RegistryDataPacket createRegistryDataPacket() {
        return new RegistryDataPacket("minecraft:dimension_type", this.dimensionTypes.stream().map(DimensionType::toRegistryEntry).toList());
    }
}

