/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import java.util.Collection;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.world.biomes.Biome;
import net.minestom.server.world.biomes.BiomeEffects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BiomeImpl
implements ProtocolObject,
Biome {
    private static final Double SNOW_TEMPERATURE = 0.15;
    private static final Registry.DynamicContainer<BiomeImpl> CONTAINER = Registry.createDynamicContainer(Registry.Resource.BIOMES, (namespace, properties) -> new BiomeImpl(Registry.biome(namespace, properties)));
    private Registry.BiomeEntry entry;
    @NotNull
    private final NamespaceID name;
    private final float temperature;
    private final float downfall;
    @NotNull
    private final BiomeEffects effects;
    @NotNull
    private final Biome.Precipitation precipitation;
    @NotNull
    private final Biome.TemperatureModifier temperatureModifier;

    static Collection<BiomeImpl> values() {
        return CONTAINER.values();
    }

    static BiomeImpl get(@NotNull String namespace) {
        return CONTAINER.get(namespace);
    }

    static BiomeImpl getSafe(@NotNull String namespace) {
        return CONTAINER.getSafe(namespace);
    }

    BiomeImpl(NamespaceID name, float temperature, float downfall, BiomeEffects effects, Biome.Precipitation precipitation, Biome.TemperatureModifier temperatureModifier) {
        this.name = name;
        this.temperature = temperature;
        this.downfall = downfall;
        this.effects = effects;
        this.precipitation = precipitation;
        this.temperatureModifier = temperatureModifier;
    }

    BiomeImpl(Registry.BiomeEntry entry) {
        this.entry = entry;
        this.name = entry.namespace();
        this.temperature = entry.temperature();
        BiomeEffects.Builder effectsBuilder = BiomeImpl.getBuilder(entry);
        this.effects = effectsBuilder.build();
        this.precipitation = entry.hasPrecipitation() ? ((double)this.temperature < SNOW_TEMPERATURE ? Biome.Precipitation.SNOW : Biome.Precipitation.RAIN) : Biome.Precipitation.NONE;
        this.downfall = entry.downfall();
        this.temperatureModifier = (double)entry.temperature() < SNOW_TEMPERATURE ? Biome.TemperatureModifier.FROZEN : Biome.TemperatureModifier.NONE;
    }

    @NotNull
    private static BiomeEffects.Builder getBuilder(Registry.BiomeEntry entry) {
        BiomeEffects.Builder effectsBuilder = BiomeEffects.builder();
        if (entry.foliageColor() != null) {
            effectsBuilder.foliageColor(entry.foliageColor());
        }
        if (entry.grassColor() != null) {
            effectsBuilder.grassColor(entry.grassColor());
        }
        if (entry.skyColor() != null) {
            effectsBuilder.skyColor(entry.skyColor());
        }
        if (entry.waterColor() != null) {
            effectsBuilder.waterColor(entry.waterColor());
        }
        if (entry.waterFogColor() != null) {
            effectsBuilder.waterFogColor(entry.waterFogColor());
        }
        if (entry.fogColor() != null) {
            effectsBuilder.fogColor(entry.fogColor());
        }
        return effectsBuilder;
    }

    @Override
    @Nullable
    public Registry.BiomeEntry registry() {
        return this.entry;
    }

    @Override
    @NotNull
    public NamespaceID namespace() {
        return this.name;
    }

    @Override
    public float temperature() {
        return this.temperature;
    }

    @Override
    public float downfall() {
        return this.downfall;
    }

    @Override
    @NotNull
    public BiomeEffects effects() {
        return this.effects;
    }

    @Override
    @NotNull
    public Biome.Precipitation precipitation() {
        return this.precipitation;
    }

    @Override
    @NotNull
    public Biome.TemperatureModifier temperatureModifier() {
        return this.temperatureModifier;
    }
}

