/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.world.biomes;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.configuration.RegistryDataPacket;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.biomes.Biome;
import net.minestom.server.world.biomes.BiomeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BiomeManager {
    private final CachedPacket registryDataPacket = new CachedPacket(this::createRegistryDataPacket);
    private final List<Biome> biomes = new CopyOnWriteArrayList<Biome>();
    private final Map<NamespaceID, Biome> biomesByName = new ConcurrentHashMap<NamespaceID, Biome>();
    private final Map<NamespaceID, Integer> idMappings = new ConcurrentHashMap<NamespaceID, Integer>();
    private final AtomicInteger ID_COUNTER = new AtomicInteger(0);

    public BiomeManager() {
        this.addBiome(BiomeImpl.get("minecraft:plains"));
    }

    public void loadVanillaBiomes() {
        for (BiomeImpl biome : BiomeImpl.values()) {
            if (this.getByName(biome.namespace()) != null) continue;
            this.addBiome(biome);
        }
    }

    public void addBiome(@NotNull Biome biome) {
        Check.stateCondition(this.getByName(biome.namespace()) != null, "The biome " + String.valueOf(biome.namespace()) + " has already been registered");
        int id = this.biomes.size();
        this.biomes.add(biome);
        this.biomesByName.put(biome.namespace(), biome);
        this.idMappings.put(biome.namespace(), id);
        this.registryDataPacket.invalidate();
    }

    public Collection<Biome> unmodifiableCollection() {
        return Collections.unmodifiableCollection(this.biomes);
    }

    @Nullable
    public Biome getById(int id) {
        return this.biomes.get(id);
    }

    @Nullable
    public Biome getByName(@NotNull NamespaceID namespaceID) {
        return this.biomesByName.get(namespaceID);
    }

    @Nullable
    public Biome getByName(@NotNull String namespaceID) {
        NamespaceID namespace = NamespaceID.from(namespaceID);
        return this.getByName(namespace);
    }

    public int getId(Biome biome) {
        return this.idMappings.getOrDefault(biome.namespace(), -1);
    }

    @NotNull
    public SendablePacket registryDataPacket() {
        return this.registryDataPacket;
    }

    @NotNull
    private RegistryDataPacket createRegistryDataPacket() {
        return new RegistryDataPacket("minecraft:worldgen/biome", this.biomes.stream().map(Biome::toRegistryEntry).toList());
    }
}

