/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.sound.Sound;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityPose;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.ItemEntity;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.attribute.AttributeInstance;
import net.minestom.server.entity.attribute.AttributeModifier;
import net.minestom.server.entity.attribute.AttributeOperation;
import net.minestom.server.entity.damage.Damage;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.metadata.LivingEntityMeta;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.entity.EntityDamageEvent;
import net.minestom.server.event.entity.EntityDeathEvent;
import net.minestom.server.event.entity.EntityFireExtinguishEvent;
import net.minestom.server.event.entity.EntitySetFireEvent;
import net.minestom.server.event.item.EntityEquipEvent;
import net.minestom.server.event.item.PickupItemEvent;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.inventory.EquipmentHandler;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.component.AttributeList;
import net.minestom.server.network.ConnectionState;
import net.minestom.server.network.packet.server.LazyPacket;
import net.minestom.server.network.packet.server.play.CollectItemPacket;
import net.minestom.server.network.packet.server.play.DamageEventPacket;
import net.minestom.server.network.packet.server.play.EntityAnimationPacket;
import net.minestom.server.network.packet.server.play.EntityAttributesPacket;
import net.minestom.server.network.packet.server.play.SoundEffectPacket;
import net.minestom.server.network.player.PlayerConnection;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.scoreboard.Team;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.thread.Acquirable;
import net.minestom.server.utils.NamespaceID;
import net.minestom.server.utils.block.BlockIterator;
import net.minestom.server.utils.time.Cooldown;
import net.minestom.server.utils.time.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public class LivingEntity
extends Entity
implements EquipmentHandler {
    private static final AttributeModifier SPRINTING_SPEED_MODIFIER = new AttributeModifier(NamespaceID.from("minecraft:sprinting"), 0.3, AttributeOperation.MULTIPLY_TOTAL);
    @ApiStatus.Internal
    public static final Set<NamespaceID> PROTECTED_MODIFIERS = Set.of(SPRINTING_SPEED_MODIFIER.id());
    protected boolean canPickupItem;
    protected Cooldown itemPickupCooldown = new Cooldown(Duration.of(5L, TimeUnit.SERVER_TICK));
    protected boolean isDead;
    protected Damage lastDamage;
    protected BoundingBox expandedBoundingBox;
    private final Map<String, AttributeInstance> attributeModifiers = new ConcurrentHashMap<String, AttributeInstance>();
    private final Collection<AttributeInstance> unmodifiableModifiers = Collections.unmodifiableCollection(this.attributeModifiers.values());
    protected boolean invulnerable;
    private int remainingFireTicks;
    private Team team;
    private int arrowCount;
    private float health = 1.0f;
    private ItemStack mainHandItem = ItemStack.AIR;
    private ItemStack offHandItem = ItemStack.AIR;
    private ItemStack helmet = ItemStack.AIR;
    private ItemStack chestplate = ItemStack.AIR;
    private ItemStack leggings = ItemStack.AIR;
    private ItemStack boots = ItemStack.AIR;
    private ItemStack bodyEquipment = ItemStack.AIR;

    public LivingEntity(@NotNull EntityType entityType, @NotNull UUID uuid) {
        super(entityType, uuid);
    }

    public LivingEntity(@NotNull EntityType entityType) {
        this(entityType, UUID.randomUUID());
    }

    @Override
    public void setSprinting(boolean sprinting) {
        super.setSprinting(sprinting);
        AttributeInstance speed = this.getAttribute(Attribute.MOVEMENT_SPEED);
        if (sprinting) {
            speed.addModifier(SPRINTING_SPEED_MODIFIER);
        } else {
            speed.removeModifier(SPRINTING_SPEED_MODIFIER);
        }
    }

    @Override
    @NotNull
    public ItemStack getEquipment(@NotNull EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.MAIN_HAND -> this.mainHandItem;
            case EquipmentSlot.OFF_HAND -> this.offHandItem;
            case EquipmentSlot.BOOTS -> this.boots;
            case EquipmentSlot.LEGGINGS -> this.leggings;
            case EquipmentSlot.CHESTPLATE -> this.chestplate;
            case EquipmentSlot.HELMET -> this.helmet;
            case EquipmentSlot.BODY -> this.bodyEquipment;
        };
    }

    @Override
    public void setEquipment(@NotNull EquipmentSlot slot, @NotNull ItemStack itemStack) {
        ItemStack oldItem = this.getEquipment(slot);
        ItemStack newItem = this.slotChangeEvent(itemStack, slot);
        switch (slot) {
            case MAIN_HAND: {
                this.mainHandItem = newItem;
                break;
            }
            case OFF_HAND: {
                this.offHandItem = newItem;
                break;
            }
            case BOOTS: {
                this.boots = newItem;
                break;
            }
            case LEGGINGS: {
                this.leggings = newItem;
                break;
            }
            case CHESTPLATE: {
                this.chestplate = newItem;
                break;
            }
            case HELMET: {
                this.helmet = newItem;
                break;
            }
            case BODY: {
                this.bodyEquipment = newItem;
            }
        }
        this.syncEquipment(slot);
        this.updateEquipmentAttributes(oldItem, newItem, slot);
    }

    private ItemStack slotChangeEvent(@NotNull ItemStack itemStack, @NotNull EquipmentSlot slot) {
        EntityEquipEvent entityEquipEvent = new EntityEquipEvent(this, itemStack, slot);
        EventDispatcher.call(entityEquipEvent);
        return entityEquipEvent.getEquippedItem();
    }

    @ApiStatus.Internal
    public void updateEquipmentAttributes(@NotNull ItemStack oldItemStack, @NotNull ItemStack newItemStack, @NotNull EquipmentSlot slot) {
        AttributeList newAttributes;
        AttributeList oldAttributes = oldItemStack.get(ItemComponent.ATTRIBUTE_MODIFIERS);
        if (oldAttributes != null) {
            for (AttributeList.Modifier modifier : oldAttributes.modifiers()) {
                if (!modifier.slot().contains(slot)) continue;
                AttributeInstance attributeInstance = this.getAttribute(modifier.attribute());
                attributeInstance.removeModifier(modifier.modifier().id());
            }
        }
        if ((newAttributes = newItemStack.get(ItemComponent.ATTRIBUTE_MODIFIERS)) != null) {
            for (AttributeList.Modifier modifier : newAttributes.modifiers()) {
                if (!modifier.slot().contains(slot)) continue;
                AttributeInstance attributeInstance = this.getAttribute(modifier.attribute());
                attributeInstance.addModifier(modifier.modifier());
            }
        }
    }

    @Override
    public void update(long time) {
        if (this.remainingFireTicks > 0 && --this.remainingFireTicks == 0) {
            EventDispatcher.callCancellable(new EntityFireExtinguishEvent(this, true), () -> this.entityMeta.setOnFire(false));
        }
        if (this.canPickupItem() && this.itemPickupCooldown.isReady(time)) {
            this.itemPickupCooldown.refreshLastUpdate(time);
            Pos loweredPosition = this.position.sub(0.0, 0.5, 0.0);
            this.instance.getEntityTracker().nearbyEntities(this.position, this.expandedBoundingBox.width(), EntityTracker.Target.ITEMS, itemEntity -> {
                Player player;
                LivingEntity patt0$temp = this;
                if (patt0$temp instanceof Player && !itemEntity.isViewer(player = (Player)patt0$temp)) {
                    return;
                }
                if (!itemEntity.isPickable()) {
                    return;
                }
                if (this.expandedBoundingBox.intersectEntity(loweredPosition, (Entity)itemEntity)) {
                    PickupItemEvent pickupItemEvent = new PickupItemEvent(this, (ItemEntity)itemEntity);
                    EventDispatcher.callCancellable(pickupItemEvent, () -> {
                        ItemStack item = itemEntity.getItemStack();
                        this.sendPacketToViewersAndSelf(new CollectItemPacket(itemEntity.getEntityId(), this.getEntityId(), item.amount()));
                        itemEntity.remove();
                    });
                }
            });
        }
    }

    public int getArrowCount() {
        return this.arrowCount;
    }

    public void setArrowCount(int arrowCount) {
        this.arrowCount = arrowCount;
        LivingEntityMeta meta = this.getLivingEntityMeta();
        if (meta != null) {
            meta.setArrowCount(arrowCount);
        }
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean invulnerable) {
        this.invulnerable = invulnerable;
    }

    public void kill() {
        this.refreshIsDead(true);
        this.triggerStatus((byte)3);
        this.setPose(EntityPose.DYING);
        this.setHealth(0.0f);
        this.velocity = Vec.ZERO;
        if (this.hasPassenger()) {
            this.getPassengers().forEach(this::removePassenger);
        }
        EntityDeathEvent entityDeathEvent = new EntityDeathEvent(this);
        EventDispatcher.call(entityDeathEvent);
    }

    public int getFireTicks() {
        return this.remainingFireTicks;
    }

    public void setFireTicks(int ticks) {
        int fireTicks = Math.max(0, ticks);
        if (fireTicks > 0) {
            EntitySetFireEvent entitySetFireEvent = new EntitySetFireEvent(this, ticks);
            EventDispatcher.call(entitySetFireEvent);
            if (entitySetFireEvent.isCancelled()) {
                return;
            }
            fireTicks = Math.max(0, entitySetFireEvent.getFireTicks());
            if (fireTicks > 0) {
                this.remainingFireTicks = fireTicks;
                this.entityMeta.setOnFire(true);
                return;
            }
        }
        if (this.remainingFireTicks != 0) {
            EntityFireExtinguishEvent entityFireExtinguishEvent = new EntityFireExtinguishEvent(this, false);
            EventDispatcher.callCancellable(entityFireExtinguishEvent, () -> this.entityMeta.setOnFire(false));
        }
        this.remainingFireTicks = fireTicks;
    }

    public boolean damage(@NotNull DynamicRegistry.Key<DamageType> type, float amount) {
        return this.damage(new Damage(type, null, null, null, amount));
    }

    public boolean damage(@NotNull Damage damage) {
        if (this.isDead()) {
            return false;
        }
        if (this.isInvulnerable() || this.isImmune(damage.getType())) {
            return false;
        }
        EntityDamageEvent entityDamageEvent = new EntityDamageEvent(this, damage, damage.getSound(this));
        EventDispatcher.callCancellable(entityDamageEvent, () -> {
            Player player;
            float additionalHearts;
            this.lastDamage = entityDamageEvent.getDamage();
            float remainingDamage = entityDamageEvent.getDamage().getAmount();
            if (entityDamageEvent.shouldAnimate()) {
                this.sendPacketToViewersAndSelf(new EntityAnimationPacket(this.getEntityId(), EntityAnimationPacket.Animation.TAKE_DAMAGE));
            }
            this.sendPacketToViewersAndSelf(new DamageEventPacket(this.getEntityId(), damage.getTypeId(), damage.getAttacker() == null ? 0 : damage.getAttacker().getEntityId() + 1, damage.getSource() == null ? 0 : damage.getSource().getEntityId() + 1, damage.getSourcePosition()));
            LivingEntity patt0$temp = this;
            if (patt0$temp instanceof Player && (additionalHearts = (player = (Player)patt0$temp).getAdditionalHearts()) > 0.0f) {
                if (remainingDamage > additionalHearts) {
                    remainingDamage -= additionalHearts;
                    player.setAdditionalHearts(0.0f);
                } else {
                    player.setAdditionalHearts(additionalHearts - remainingDamage);
                    remainingDamage = 0.0f;
                }
            }
            this.setHealth(this.getHealth() - remainingDamage);
            SoundEvent sound = entityDamageEvent.getSound();
            if (sound != null) {
                Sound.Source soundCategory = this instanceof Player ? Sound.Source.PLAYER : Sound.Source.HOSTILE;
                this.sendPacketToViewersAndSelf(new SoundEffectPacket(sound, soundCategory, this.getPosition(), 1.0f, 1.0f, 0L));
            }
        });
        return !entityDamageEvent.isCancelled();
    }

    public boolean isImmune(@NotNull DynamicRegistry.Key<DamageType> type) {
        return false;
    }

    public float getHealth() {
        return this.health;
    }

    public void setHealth(float health) {
        LivingEntityMeta meta;
        this.health = Math.min(health, (float)this.getAttributeValue(Attribute.MAX_HEALTH));
        if (this.health <= 0.0f && !this.isDead) {
            this.kill();
        }
        if ((meta = this.getLivingEntityMeta()) != null) {
            meta.setHealth(this.health);
        }
    }

    @Nullable
    public Damage getLastDamageSource() {
        return this.lastDamage;
    }

    public void heal() {
        this.setHealth((float)this.getAttributeValue(Attribute.MAX_HEALTH));
    }

    @NotNull
    public AttributeInstance getAttribute(@NotNull Attribute attribute) {
        return this.attributeModifiers.computeIfAbsent(attribute.name(), s -> new AttributeInstance(attribute, this::onAttributeChanged));
    }

    @NotNull
    public @UnmodifiableView Collection<AttributeInstance> getAttributes() {
        return this.unmodifiableModifiers;
    }

    protected void onAttributeChanged(@NotNull AttributeInstance attributeInstance) {
        boolean self = false;
        LivingEntity livingEntity = this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerConnection playerConnection = player.playerConnection;
            self = playerConnection != null && playerConnection.getConnectionState() == ConnectionState.PLAY;
        }
        EntityAttributesPacket propertiesPacket = new EntityAttributesPacket(this.getEntityId(), List.of(new EntityAttributesPacket.Property(attributeInstance.attribute(), attributeInstance.getBaseValue(), attributeInstance.getModifiers())));
        if (self) {
            this.sendPacketToViewersAndSelf(propertiesPacket);
        } else {
            this.sendPacketToViewers(propertiesPacket);
        }
    }

    public double getAttributeValue(@NotNull Attribute attribute) {
        AttributeInstance instance = this.attributeModifiers.get(attribute.name());
        return instance != null ? instance.getValue() : attribute.defaultValue();
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean canPickupItem() {
        return this.canPickupItem;
    }

    public void setCanPickupItem(boolean canPickupItem) {
        this.canPickupItem = canPickupItem;
    }

    @Override
    public void updateNewViewer(@NotNull Player player) {
        super.updateNewViewer(player);
        player.sendPacket(new LazyPacket(this::getEquipmentsPacket));
        player.sendPacket(new LazyPacket(this::getPropertiesPacket));
    }

    @Override
    public void setBoundingBox(BoundingBox boundingBox) {
        super.setBoundingBox(boundingBox);
        this.expandedBoundingBox = boundingBox.expand(1.0, 0.5, 1.0);
    }

    public void swingMainHand() {
        this.swingMainHand(false);
    }

    public void swingOffHand() {
        this.swingOffHand(false);
    }

    @ApiStatus.Internal
    public void swingMainHand(boolean fromClient) {
        this.swingHand(fromClient, EntityAnimationPacket.Animation.SWING_MAIN_ARM);
    }

    @ApiStatus.Internal
    public void swingOffHand(boolean fromClient) {
        this.swingHand(fromClient, EntityAnimationPacket.Animation.SWING_OFF_HAND);
    }

    private void swingHand(boolean fromClient, EntityAnimationPacket.Animation animation) {
        EntityAnimationPacket packet = new EntityAnimationPacket(this.getEntityId(), animation);
        if (fromClient) {
            this.sendPacketToViewers(packet);
        } else {
            this.sendPacketToViewersAndSelf(packet);
        }
    }

    public void refreshActiveHand(boolean isHandActive, boolean offHand, boolean riptideSpinAttack) {
        LivingEntityMeta meta = this.getLivingEntityMeta();
        if (meta != null) {
            meta.setNotifyAboutChanges(false);
            meta.setHandActive(isHandActive);
            meta.setActiveHand(offHand ? PlayerHand.OFF : PlayerHand.MAIN);
            meta.setInRiptideSpinAttack(riptideSpinAttack);
            meta.setNotifyAboutChanges(true);
            this.updatePose();
        }
    }

    public boolean isFlyingWithElytra() {
        return this.entityMeta.isFlyingWithElytra();
    }

    public void setFlyingWithElytra(boolean isFlying) {
        this.entityMeta.setFlyingWithElytra(isFlying);
        this.updatePose();
    }

    protected void refreshIsDead(boolean isDead) {
        this.isDead = isDead;
    }

    @NotNull
    protected EntityAttributesPacket getPropertiesPacket() {
        ArrayList<EntityAttributesPacket.Property> properties = new ArrayList<EntityAttributesPacket.Property>();
        for (AttributeInstance instance : this.attributeModifiers.values()) {
            properties.add(new EntityAttributesPacket.Property(instance.attribute(), instance.getBaseValue(), instance.getModifiers()));
        }
        return new EntityAttributesPacket(this.getEntityId(), properties);
    }

    public void setTeam(@Nullable Team team) {
        String member;
        if (this.team == team) {
            return;
        }
        LivingEntity livingEntity = this;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            v0 = player.getUsername();
        } else {
            v0 = member = this.getUuid().toString();
        }
        if (this.team != null) {
            this.team.removeMember(member);
        }
        this.team = team;
        if (team != null) {
            team.addMember(member);
        }
    }

    @Nullable
    public Team getTeam() {
        return this.team;
    }

    @Nullable
    public Point getTargetBlockPosition(int maxDistance) {
        BlockIterator it = new BlockIterator(this, maxDistance);
        while (it.hasNext()) {
            Point position = (Point)it.next();
            if (this.getInstance().getBlock(position).isAir()) continue;
            return position;
        }
        return null;
    }

    @Nullable
    public LivingEntityMeta getLivingEntityMeta() {
        if (this.entityMeta instanceof LivingEntityMeta) {
            return (LivingEntityMeta)this.entityMeta;
        }
        return null;
    }

    @Override
    public void takeKnockback(float strength, double x, double z) {
        super.takeKnockback(strength *= (float)(1.0 - this.getAttributeValue(Attribute.KNOCKBACK_RESISTANCE)), x, z);
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public Acquirable<? extends LivingEntity> acquirable() {
        return super.acquirable();
    }
}

