/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata;

import java.util.List;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.entity.metadata.EntityMeta;
import net.minestom.server.particle.Particle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LivingEntityMeta
extends EntityMeta {
    public static final byte OFFSET = 8;
    public static final byte MAX_OFFSET = 15;
    private static final byte IS_HAND_ACTIVE_BIT = 1;
    private static final byte ACTIVE_HAND_BIT = 2;
    private static final byte IS_IN_SPIN_ATTACK_BIT = 4;

    protected LivingEntityMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    public boolean isHandActive() {
        return this.getMaskBit(8, (byte)1);
    }

    public void setHandActive(boolean value) {
        this.setMaskBit(8, (byte)1, value);
    }

    @NotNull
    public PlayerHand getActiveHand() {
        return this.getMaskBit(8, (byte)2) ? PlayerHand.OFF : PlayerHand.MAIN;
    }

    public void setActiveHand(@NotNull PlayerHand hand) {
        this.setMaskBit(8, (byte)2, hand == PlayerHand.OFF);
    }

    public boolean isInRiptideSpinAttack() {
        return this.getMaskBit(8, (byte)4);
    }

    public void setInRiptideSpinAttack(boolean value) {
        this.setMaskBit(8, (byte)4, value);
    }

    public float getHealth() {
        return this.metadata.getIndex(9, Float.valueOf(1.0f)).floatValue();
    }

    public void setHealth(float value) {
        this.metadata.setIndex(9, Metadata.Float(value));
    }

    @NotNull
    public List<Particle> getEffectParticles() {
        return this.metadata.getIndex(10, List.of());
    }

    public void setEffectParticles(@NotNull List<Particle> value) {
        this.metadata.setIndex(10, Metadata.ParticleList(value));
    }

    public boolean isPotionEffectAmbient() {
        return this.metadata.getIndex(11, false);
    }

    public void setPotionEffectAmbient(boolean value) {
        this.metadata.setIndex(11, Metadata.Boolean(value));
    }

    public int getArrowCount() {
        return this.metadata.getIndex(12, 0);
    }

    public void setArrowCount(int value) {
        this.metadata.setIndex(12, Metadata.VarInt(value));
    }

    public int getBeeStingerCount() {
        return this.metadata.getIndex(13, 0);
    }

    public void setBeeStingerCount(int value) {
        this.metadata.setIndex(13, Metadata.VarInt(value));
    }

    @Nullable
    public Point getBedInWhichSleepingPosition() {
        return this.metadata.getIndex(14, null);
    }

    public void setBedInWhichSleepingPosition(@Nullable Point value) {
        this.metadata.setIndex(14, Metadata.OptBlockPosition(value));
    }
}

