/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.villager;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Metadata;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.villager.AbstractVillagerMeta;
import org.jetbrains.annotations.NotNull;

public class VillagerMeta
extends AbstractVillagerMeta {
    public static final byte OFFSET = 18;
    public static final byte MAX_OFFSET = 19;

    public VillagerMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @NotNull
    public VillagerData getVillagerData() {
        int[] data = this.metadata.getIndex(18, null);
        if (data == null) {
            return new VillagerData(Type.PLAINS, Profession.NONE, Level.NOVICE);
        }
        return new VillagerData(Type.VALUES[data[0]], Profession.VALUES[data[1]], Level.VALUES[data[2] - 1]);
    }

    public void setVillagerData(@NotNull VillagerData data) {
        this.metadata.setIndex(18, Metadata.VillagerData(data.type.ordinal(), data.profession.ordinal(), data.level.ordinal() + 1));
    }

    public static class VillagerData {
        private Type type;
        private Profession profession;
        private Level level;

        public VillagerData(@NotNull Type type, @NotNull Profession profession, @NotNull Level level) {
            this.type = type;
            this.profession = profession;
            this.level = level;
        }

        @NotNull
        public Type getType() {
            return this.type;
        }

        public void setType(@NotNull Type type) {
            this.type = type;
        }

        @NotNull
        public Profession getProfession() {
            return this.profession;
        }

        public void setProfession(@NotNull Profession profession) {
            this.profession = profession;
        }

        @NotNull
        public Level getLevel() {
            return this.level;
        }

        public void setLevel(@NotNull Level level) {
            this.level = level;
        }
    }

    public static enum Type {
        DESERT,
        JUNGLE,
        PLAINS,
        SAVANNA,
        SNOW,
        SWAMP,
        TAIGA;

        public static final Type[] VALUES;

        static {
            VALUES = Type.values();
        }
    }

    public static enum Profession {
        NONE,
        ARMORER,
        BUTCHER,
        CARTOGRAPHER,
        CLERIC,
        FARMER,
        FISHERMAN,
        FLETCHER,
        LEATHERWORKER,
        LIBRARIAN,
        NITWIT,
        UNEMPLOYED,
        MASON,
        SHEPHERD,
        TOOLSMITH,
        WEAPONSMITH;

        public static final Profession[] VALUES;

        static {
            VALUES = Profession.values();
        }
    }

    public static enum Level {
        NOVICE,
        APPRENTICE,
        JOURNEYMAN,
        EXPERT,
        MASTER;

        public static final Level[] VALUES;

        static {
            VALUES = Level.values();
        }
    }
}

