/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import net.minestom.server.MinecraftServer;
import net.minestom.server.instance.palette.AdaptivePalette;
import net.minestom.server.instance.palette.Palette;
import net.minestom.server.instance.palette.Palettes;
import net.minestom.server.instance.palette.SpecializedPalette;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.NotNull;

final class PaletteIndirect
implements SpecializedPalette,
Cloneable {
    private static final ThreadLocal<int[]> WRITE_CACHE = ThreadLocal.withInitial(() -> new int[4096]);
    private final int dimension;
    private final int maxBitsPerEntry;
    private byte bitsPerEntry;
    private int count;
    long[] values;
    IntArrayList paletteToValueList;
    private Int2IntOpenHashMap valueToPaletteMap;

    PaletteIndirect(int dimension, int maxBitsPerEntry, byte bitsPerEntry, int count, int[] palette, long[] values) {
        this.dimension = dimension;
        this.maxBitsPerEntry = maxBitsPerEntry;
        this.bitsPerEntry = bitsPerEntry;
        this.count = count;
        this.values = values;
        this.paletteToValueList = new IntArrayList(palette.length);
        this.valueToPaletteMap = new Int2IntOpenHashMap(palette.length);
        this.valueToPaletteMap.defaultReturnValue(-1);
        for (int i = 0; i < palette.length; ++i) {
            this.paletteToValueList.add(palette[i]);
            this.valueToPaletteMap.put(palette[i], i);
        }
        this.values = new long[Palettes.arrayLength(this.dimension(), bitsPerEntry)];
    }

    PaletteIndirect(int dimension, int maxBitsPerEntry, byte bitsPerEntry) {
        this(dimension, maxBitsPerEntry, bitsPerEntry, 0, new int[]{0}, new long[Palettes.arrayLength(dimension, bitsPerEntry)]);
    }

    PaletteIndirect(AdaptivePalette palette) {
        this(palette.dimension, palette.maxBitsPerEntry, palette.defaultBitsPerEntry);
    }

    @Override
    public int get(int x, int y, int z) {
        int value = Palettes.read(this.dimension(), this.bitsPerEntry, this.values, x, y, z);
        return this.hasPalette() ? this.paletteToValueList.getInt(value) : value;
    }

    @Override
    public void getAll(@NotNull Palette.EntryConsumer consumer) {
        this.retrieveAll(consumer, true);
    }

    @Override
    public void getAllPresent(@NotNull Palette.EntryConsumer consumer) {
        this.retrieveAll(consumer, false);
    }

    @Override
    public void set(int x, int y, int z, int value) {
        value = this.getPaletteIndex(value);
        int oldValue = Palettes.write(this.dimension(), this.bitsPerEntry, this.values, x, y, z, value);
        boolean currentAir = oldValue == 0;
        if (currentAir != (value == 0)) {
            this.count += currentAir ? 1 : -1;
        }
    }

    @Override
    public void fill(int value) {
        if (value == 0) {
            Arrays.fill(this.values, 0L);
            this.count = 0;
            return;
        }
        value = this.getPaletteIndex(value);
        Palettes.fill(this.bitsPerEntry, this.values, value);
        this.count = this.maxSize();
    }

    @Override
    public void setAll(@NotNull Palette.EntrySupplier supplier) {
        int[] cache = WRITE_CACHE.get();
        int dimension = this.dimension();
        int fillValue = -1;
        int count = 0;
        int index = 0;
        for (int y = 0; y < dimension; ++y) {
            for (int z = 0; z < dimension; ++z) {
                for (int x = 0; x < dimension; ++x) {
                    int value = supplier.get(x, y, z);
                    if (fillValue != -2) {
                        if (fillValue == -1) {
                            fillValue = value;
                        } else if (fillValue != value) {
                            fillValue = -2;
                        }
                    }
                    if (value != 0) {
                        value = this.getPaletteIndex(value);
                        ++count;
                    }
                    cache[index++] = value;
                }
            }
        }
        assert (index == this.maxSize());
        if (fillValue < 0) {
            this.updateAll(cache);
            this.count = count;
        } else {
            this.fill(fillValue);
        }
    }

    @Override
    public void replace(int x, int y, int z, @NotNull IntUnaryOperator operator) {
        int newValue;
        int oldValue = this.get(x, y, z);
        if (oldValue != (newValue = operator.applyAsInt(oldValue))) {
            this.set(x, y, z, newValue);
        }
    }

    @Override
    public void replaceAll(@NotNull Palette.EntryFunction function) {
        int[] cache = WRITE_CACHE.get();
        AtomicInteger arrayIndex = new AtomicInteger();
        AtomicInteger count = new AtomicInteger();
        this.getAll((x, y, z, value) -> {
            int newValue = function.apply(x, y, z, value);
            int index = arrayIndex.getPlain();
            arrayIndex.setPlain(index + 1);
            int n = cache[index] = newValue != value ? this.getPaletteIndex(newValue) : value;
            if (newValue != 0) {
                count.setPlain(count.getPlain() + 1);
            }
        });
        assert (arrayIndex.getPlain() == this.maxSize());
        this.updateAll(cache);
        this.count = count.getPlain();
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public int bitsPerEntry() {
        return this.bitsPerEntry;
    }

    @Override
    public int maxBitsPerEntry() {
        return this.maxBitsPerEntry;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    @NotNull
    public SpecializedPalette clone() {
        try {
            PaletteIndirect palette = (PaletteIndirect)super.clone();
            palette.values = this.values != null ? (long[])this.values.clone() : null;
            palette.paletteToValueList = this.paletteToValueList.clone();
            palette.valueToPaletteMap = this.valueToPaletteMap.clone();
            palette.count = this.count;
            return palette;
        }
        catch (CloneNotSupportedException e) {
            MinecraftServer.getExceptionManager().handleException(e);
            throw new IllegalStateException("Weird thing happened");
        }
    }

    private void retrieveAll(@NotNull Palette.EntryConsumer consumer, boolean consumeEmpty) {
        if (!consumeEmpty && this.count == 0) {
            return;
        }
        long[] values = this.values;
        int dimension = this.dimension();
        byte bitsPerEntry = this.bitsPerEntry;
        int magicMask = (1 << bitsPerEntry) - 1;
        int valuesPerLong = 64 / bitsPerEntry;
        int size = this.maxSize();
        int dimensionMinus = dimension - 1;
        int[] ids = this.hasPalette() ? this.paletteToValueList.elements() : null;
        int dimensionBitCount = MathUtils.bitsToRepresent(dimensionMinus);
        int shiftedDimensionBitCount = dimensionBitCount << 1;
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            int startIndex = i * valuesPerLong;
            int endIndex = Math.min(startIndex + valuesPerLong, size);
            for (int index = startIndex; index < endIndex; ++index) {
                int bitIndex = (index - startIndex) * bitsPerEntry;
                int paletteIndex = (int)(value >> bitIndex & (long)magicMask);
                if (!consumeEmpty && paletteIndex == 0) continue;
                int y = index >> shiftedDimensionBitCount;
                int z = index >> dimensionBitCount & dimensionMinus;
                int x = index & dimensionMinus;
                int result = ids != null && paletteIndex < ids.length ? ids[paletteIndex] : paletteIndex;
                consumer.accept(x, y, z, result);
            }
        }
    }

    private void updateAll(int[] paletteValues) {
        int size = this.maxSize();
        assert (paletteValues.length >= size);
        byte bitsPerEntry = this.bitsPerEntry;
        int valuesPerLong = 64 / bitsPerEntry;
        long clear = (1L << bitsPerEntry) - 1L;
        long[] values = this.values;
        for (int i = 0; i < values.length; ++i) {
            long block = values[i];
            int startIndex = i * valuesPerLong;
            int endIndex = Math.min(startIndex + valuesPerLong, size);
            for (int index = startIndex; index < endIndex; ++index) {
                int bitIndex = (index - startIndex) * bitsPerEntry;
                block = block & (clear << bitIndex ^ 0xFFFFFFFFFFFFFFFFL) | (long)paletteValues[index] << bitIndex;
            }
            values[i] = block;
        }
    }

    void resize(byte newBitsPerEntry) {
        newBitsPerEntry = (byte)(newBitsPerEntry > this.maxBitsPerEntry() ? 15 : (int)newBitsPerEntry);
        PaletteIndirect palette = new PaletteIndirect(this.dimension, this.maxBitsPerEntry, newBitsPerEntry);
        palette.paletteToValueList = this.paletteToValueList;
        palette.valueToPaletteMap = this.valueToPaletteMap;
        this.getAll(palette::set);
        this.bitsPerEntry = palette.bitsPerEntry;
        this.values = palette.values;
        assert (this.count == palette.count);
    }

    private int getPaletteIndex(int value) {
        byte bpe;
        if (!this.hasPalette()) {
            return value;
        }
        int lastPaletteIndex = this.paletteToValueList.size();
        if (lastPaletteIndex >= PaletteIndirect.maxPaletteSize(bpe = this.bitsPerEntry)) {
            this.resize((byte)(bpe + 1));
            return this.getPaletteIndex(value);
        }
        int lookup = this.valueToPaletteMap.putIfAbsent(value, lastPaletteIndex);
        if (lookup != -1) {
            return lookup;
        }
        this.paletteToValueList.add(value);
        assert (lastPaletteIndex < PaletteIndirect.maxPaletteSize(bpe));
        return lastPaletteIndex;
    }

    boolean hasPalette() {
        return this.bitsPerEntry <= this.maxBitsPerEntry();
    }

    static int maxPaletteSize(int bitsPerEntry) {
        return 1 << bitsPerEntry;
    }
}

