/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Player;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.InventoryProperty;
import net.minestom.server.inventory.InventoryType;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.click.ClickType;
import net.minestom.server.inventory.click.InventoryClickResult;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.OpenWindowPacket;
import net.minestom.server.network.packet.server.play.WindowPropertyPacket;
import net.minestom.server.utils.inventory.PlayerInventoryUtils;
import org.jetbrains.annotations.NotNull;

public non-sealed class Inventory
extends AbstractInventory {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private final byte id = Inventory.generateId();
    private final InventoryType inventoryType;
    private Component title;
    private final int offset;

    public Inventory(@NotNull InventoryType inventoryType, @NotNull Component title) {
        super(inventoryType.getSize());
        this.inventoryType = inventoryType;
        this.title = title;
        this.offset = this.getSize();
    }

    public Inventory(@NotNull InventoryType inventoryType, @NotNull String title) {
        this(inventoryType, (Component)Component.text((String)title));
    }

    private static byte generateId() {
        return (byte)ID_COUNTER.updateAndGet(i -> i + 1 >= 128 ? 1 : i + 1);
    }

    @NotNull
    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    public void setTitle(@NotNull Component title) {
        this.title = title;
        this.sendPacketToViewers(new OpenWindowPacket(this.getWindowId(), this.getInventoryType().getWindowType(), title));
        this.update();
    }

    @Override
    public byte getWindowId() {
        return this.id;
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        if (!this.viewers.add(player)) {
            return false;
        }
        player.sendPacket(new OpenWindowPacket(this.id, this.inventoryType.getWindowType(), this.title));
        this.update(player);
        return true;
    }

    @Override
    public boolean removeViewer(@NotNull Player player) {
        if (!super.removeViewer(player)) {
            return false;
        }
        this.clickProcessor.clearCache(player);
        return true;
    }

    @Deprecated
    @NotNull
    public ItemStack getCursorItem(@NotNull Player player) {
        return player.getInventory().getCursorItem();
    }

    @Deprecated
    public void setCursorItem(@NotNull Player player, @NotNull ItemStack cursorItem) {
        player.getInventory().setCursorItem(cursorItem);
    }

    protected void sendProperty(@NotNull InventoryProperty property, short value) {
        this.sendPacketToViewers(new WindowPropertyPacket(this.getWindowId(), property.getProperty(), value));
    }

    @Override
    public boolean leftClick(@NotNull Player player, int slot) {
        ItemStack clicked;
        int clickSlot;
        boolean isInWindow;
        PlayerInventory playerInventory = player.getInventory();
        ItemStack cursor = playerInventory.getCursorItem();
        AbstractInventory clickedInventory = isInWindow ? this : playerInventory;
        InventoryClickResult clickResult = this.clickProcessor.leftClick(player, clickedInventory, clickSlot = (isInWindow = this.isClickInWindow(slot)) ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset), clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot), cursor);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        playerInventory.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, clickedInventory, slot, ClickType.LEFT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean rightClick(@NotNull Player player, int slot) {
        ItemStack clicked;
        int clickSlot;
        boolean isInWindow;
        PlayerInventory playerInventory = player.getInventory();
        ItemStack cursor = playerInventory.getCursorItem();
        AbstractInventory clickedInventory = isInWindow ? this : playerInventory;
        InventoryClickResult clickResult = this.clickProcessor.rightClick(player, clickedInventory, clickSlot = (isInWindow = this.isClickInWindow(slot)) ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset), clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot), cursor);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        playerInventory.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, clickedInventory, slot, ClickType.RIGHT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean shiftClick(@NotNull Player player, int slot) {
        ItemStack cursor;
        ItemStack clicked;
        int clickSlot;
        boolean isInWindow;
        PlayerInventory playerInventory = player.getInventory();
        InventoryClickResult clickResult = this.clickProcessor.shiftClick(isInWindow ? this : playerInventory, isInWindow ? playerInventory : this, 0, isInWindow ? playerInventory.getInnerSize() : this.getInnerSize(), 1, player, clickSlot = (isInWindow = this.isClickInWindow(slot)) ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset), clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot), cursor = playerInventory.getCursorItem());
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        this.updateAll(player);
        playerInventory.setCursorItem(clickResult.getCursor());
        return true;
    }

    @Override
    public boolean changeHeld(@NotNull Player player, int slot, int key) {
        ItemStack heldItem;
        ItemStack clicked;
        int clickSlot;
        int convertedKey = key == 40 ? 45 : key;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        AbstractInventory clickedInventory = isInWindow ? this : playerInventory;
        InventoryClickResult clickResult = this.clickProcessor.changeHeld(player, clickedInventory, clickSlot = isInWindow ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset), convertedKey, clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot), heldItem = playerInventory.getItemStack(convertedKey));
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        playerInventory.setItemStack(convertedKey, clickResult.getCursor());
        this.callClickEvent(player, clickedInventory, slot, ClickType.CHANGE_HELD, clicked, playerInventory.getCursorItem());
        return true;
    }

    @Override
    public boolean middleClick(@NotNull Player player, int slot) {
        this.update(player);
        return false;
    }

    @Override
    public boolean drop(@NotNull Player player, boolean all, int slot, int button) {
        ItemStack cursor;
        ItemStack clicked;
        int clickSlot;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        boolean outsideDrop = slot == -999;
        int n = clickSlot = isInWindow ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset);
        InventoryClickResult clickResult = this.clickProcessor.drop(player, isInWindow ? this : playerInventory, all, clickSlot, button, clicked = outsideDrop ? ItemStack.AIR : (isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot)), cursor = playerInventory.getCursorItem());
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        ItemStack resultClicked = clickResult.getClicked();
        if (!outsideDrop && resultClicked != null) {
            if (isInWindow) {
                this.setItemStack(slot, resultClicked);
            } else {
                playerInventory.setItemStack(clickSlot, resultClicked);
            }
        }
        playerInventory.setCursorItem(clickResult.getCursor());
        return true;
    }

    @Override
    public boolean dragging(@NotNull Player player, int slot, int button) {
        int clickSlot;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        int n = clickSlot = isInWindow ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset);
        ItemStack clicked = slot != -999 ? (isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot)) : ItemStack.AIR;
        ItemStack cursor = playerInventory.getCursorItem();
        InventoryClickResult clickResult = this.clickProcessor.dragging(player, slot != -999 ? (isInWindow ? this : playerInventory) : null, clickSlot, button, clicked, cursor);
        if (clickResult == null || clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        playerInventory.setCursorItem(clickResult.getCursor());
        this.updateAll(player);
        return true;
    }

    @Override
    public boolean doubleClick(@NotNull Player player, int slot) {
        int clickSlot;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        int n = clickSlot = isInWindow ? slot : PlayerInventoryUtils.convertSlot(slot, this.offset);
        ItemStack clicked = slot != -999 ? (isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot)) : ItemStack.AIR;
        ItemStack cursor = playerInventory.getCursorItem();
        InventoryClickResult clickResult = this.clickProcessor.doubleClick(isInWindow ? this : playerInventory, this, player, clickSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        playerInventory.setCursorItem(clickResult.getCursor());
        this.updateAll(player);
        return true;
    }

    private boolean isClickInWindow(int slot) {
        return slot < this.getSize();
    }

    private void updateAll(Player player) {
        player.getInventory().update();
        this.update(player);
    }
}

