/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.item.ItemComponent;
import net.minestom.server.item.ItemStackImpl;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.CustomData;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface ItemStack
extends TagReadable,
DataComponent.Holder,
HoverEventSource<HoverEvent.ShowItem>
permits ItemStackImpl {
    @NotNull
    public static final NetworkBuffer.Type<ItemStack> NETWORK_TYPE = new NetworkBuffer.Type<ItemStack>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, ItemStack value) {
            if (value.isAir()) {
                buffer.write(NetworkBuffer.VAR_INT, 0);
                return;
            }
            buffer.write(NetworkBuffer.VAR_INT, value.amount());
            buffer.write(NetworkBuffer.VAR_INT, value.material().id());
            buffer.write(ItemComponent.PATCH_NETWORK_TYPE, ((ItemStackImpl)value).components());
        }

        @Override
        public ItemStack read(@NotNull NetworkBuffer buffer) {
            int amount = buffer.read(NetworkBuffer.VAR_INT);
            if (amount <= 0) {
                return AIR;
            }
            Material material = Material.fromId(buffer.read(NetworkBuffer.VAR_INT));
            DataComponentMap components = buffer.read(ItemComponent.PATCH_NETWORK_TYPE);
            return ItemStackImpl.create(material, amount, components);
        }
    };
    @NotNull
    public static final NetworkBuffer.Type<ItemStack> STRICT_NETWORK_TYPE = NETWORK_TYPE.transform(itemStack -> {
        Check.argCondition(itemStack.amount() == 0 || itemStack.isAir(), "ItemStack cannot be empty");
        return itemStack;
    }, itemStack -> {
        Check.argCondition(itemStack.amount() == 0 || itemStack.isAir(), "ItemStack cannot be empty");
        return itemStack;
    });
    @NotNull
    public static final BinaryTagSerializer<ItemStack> NBT_TYPE = BinaryTagSerializer.COMPOUND.map(ItemStackImpl::fromCompound, ItemStackImpl::toCompound);
    @NotNull
    public static final ItemStack AIR = ItemStack.of(Material.AIR);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static Builder builder(@NotNull Material material) {
        return new ItemStackImpl.Builder(material, 1);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material) {
        return ItemStack.of(material, 1);
    }

    @Contract(value="_ ,_ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material, int amount) {
        return ItemStackImpl.create(material, amount);
    }

    @Contract(value="_ ,_ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material, @NotNull DataComponentMap components) {
        return ItemStackImpl.create(material, 1, components);
    }

    @Contract(value="_ ,_, _ -> new", pure=true)
    @NotNull
    public static ItemStack of(@NotNull Material material, int amount, @NotNull DataComponentMap components) {
        return ItemStackImpl.create(material, amount, components);
    }

    @NotNull
    public static ItemStack fromItemNBT(@NotNull CompoundBinaryTag nbtCompound) {
        BinaryTagSerializer.ContextWithRegistries context = new BinaryTagSerializer.ContextWithRegistries(MinecraftServer.process(), false);
        return NBT_TYPE.read(context, (BinaryTag)nbtCompound);
    }

    @Contract(pure=true)
    @NotNull
    public Material material();

    @Contract(pure=true)
    public int amount();

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack with(@NotNull @NotNull Consumer<@NotNull Builder> var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack withMaterial(@NotNull Material var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack withAmount(int var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withAmount(@NotNull IntUnaryOperator intUnaryOperator) {
        return this.withAmount(intUnaryOperator.applyAsInt(this.amount()));
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public <T> ItemStack with(@NotNull DataComponent<T> var1, @NotNull T var2);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack with(@NotNull DataComponent<Unit> component) {
        return this.with(component, Unit.INSTANCE);
    }

    @NotNull
    default public <T> ItemStack with(@NotNull DataComponent<T> component, @NotNull UnaryOperator<T> operator) {
        T value = this.get(component);
        if (value == null) {
            return this;
        }
        return this.with(component, operator.apply(value));
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack without(@NotNull DataComponent<?> var1);

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withCustomName(@NotNull Component customName) {
        return this.with(ItemComponent.CUSTOM_NAME, customName);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withLore(Component ... lore) {
        return this.with(ItemComponent.LORE, List.of(lore));
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    default public ItemStack withLore(@NotNull List<Component> lore) {
        return this.with(ItemComponent.LORE, lore);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withCustomModelData(int customModelData) {
        return this.with(ItemComponent.CUSTOM_MODEL_DATA, customModelData);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withGlowing(boolean glowing) {
        return this.with(ItemComponent.ENCHANTMENT_GLINT_OVERRIDE, glowing);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    default public ItemStack withoutExtraTooltip() {
        return this.builder().hideExtraTooltip().build();
    }

    @Contract(pure=true)
    default public int maxStackSize() {
        return this.get(ItemComponent.MAX_STACK_SIZE, 64);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    default public ItemStack withMaxStackSize(int maxStackSize) {
        return this.with(ItemComponent.MAX_STACK_SIZE, maxStackSize);
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    default public <T> ItemStack withTag(@NotNull Tag<T> tag, @Nullable T value) {
        return this.with(ItemComponent.CUSTOM_DATA, this.get(ItemComponent.CUSTOM_DATA, CustomData.EMPTY).withTag(tag, value));
    }

    @Override
    @Contract(pure=true)
    default public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return this.get(ItemComponent.CUSTOM_DATA, CustomData.EMPTY).getTag(tag);
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public ItemStack consume(int var1);

    @Contract(pure=true)
    default public boolean isAir() {
        return this.material() == Material.AIR;
    }

    @Contract(pure=true)
    public boolean isSimilar(@NotNull ItemStack var1);

    @NotNull
    public Builder builder();

    @NotNull
    public CompoundBinaryTag toItemNBT();

    @NotNull
    default public HoverEvent<HoverEvent.ShowItem> asHoverEvent(@NotNull UnaryOperator<HoverEvent.ShowItem> op) {
        try {
            BinaryTagHolder tagHolder = BinaryTagHolder.encode((Object)((CompoundBinaryTag)NBT_TYPE.write(this)), MinestomAdventure.NBT_CODEC);
            return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.showItem((Keyed)this.material(), (int)this.amount(), (BinaryTagHolder)tagHolder))));
        }
        catch (IOException e) {
            throw new RuntimeException("failed to encode itemstack nbt", e);
        }
    }

    @NotNull
    public static Collection<Component> textComponents(@NotNull ItemStack itemStack) {
        Component itemName;
        ArrayList<Component> components = new ArrayList<Component>(itemStack.get(ItemComponent.LORE, List.of()));
        Component displayName = itemStack.get(ItemComponent.CUSTOM_NAME);
        if (displayName != null) {
            components.add(displayName);
        }
        if ((itemName = itemStack.get(ItemComponent.ITEM_NAME)) != null) {
            components.add(itemName);
        }
        return List.copyOf(components);
    }

    @NotNull
    public static ItemStack copyWithOperator(@NotNull ItemStack itemStack, @NotNull UnaryOperator<Component> operator) {
        return itemStack.with(ItemComponent.CUSTOM_NAME, operator).with(ItemComponent.ITEM_NAME, operator).with(ItemComponent.LORE, lines -> {
            ArrayList translatedComponents = new ArrayList();
            lines.forEach(component -> translatedComponents.add((Component)operator.apply((Component)component)));
            return translatedComponents;
        });
    }

    public static sealed interface Builder
    permits ItemStackImpl.Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder material(@NotNull Material var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder amount(int var1);

        @Contract(value="_, _ -> this")
        @NotNull
        public <T> Builder set(@NotNull DataComponent<T> var1, T var2);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder set(@NotNull DataComponent<Unit> component) {
            return this.set(component, Unit.INSTANCE);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder remove(@NotNull DataComponent<?> var1);

        @NotNull
        default public Builder customName(@NotNull Component customName) {
            return this.set(ItemComponent.CUSTOM_NAME, customName);
        }

        @NotNull
        default public Builder lore(Component ... lore) {
            return this.set(ItemComponent.LORE, List.of(lore));
        }

        @NotNull
        default public Builder lore(@NotNull List<Component> lore) {
            return this.set(ItemComponent.LORE, lore);
        }

        @NotNull
        default public Builder customModelData(int customModelData) {
            return this.set(ItemComponent.CUSTOM_MODEL_DATA, Integer.valueOf(customModelData));
        }

        @NotNull
        default public Builder glowing() {
            return this.set(ItemComponent.ENCHANTMENT_GLINT_OVERRIDE, Boolean.valueOf(true));
        }

        @NotNull
        default public Builder glowing(boolean glowing) {
            return this.set(ItemComponent.ENCHANTMENT_GLINT_OVERRIDE, Boolean.valueOf(glowing));
        }

        @NotNull
        default public Builder maxStackSize(int maxStackSize) {
            return this.set(ItemComponent.MAX_STACK_SIZE, Integer.valueOf(maxStackSize));
        }

        @NotNull
        public Builder hideExtraTooltip();

        @Contract(value="_, _ -> this")
        @NotNull
        public <T> Builder set(@NotNull Tag<T> var1, @Nullable T var2);

        default public <T> void setTag(@NotNull Tag<T> tag, @Nullable T value) {
            this.set(tag, value);
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public ItemStack build();
    }
}

