/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.item.Material;
import net.minestom.server.item.armor.TrimMaterial;
import net.minestom.server.registry.Registry;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TrimMaterialImpl
extends Record
implements TrimMaterial {
    @NotNull
    private final String assetName;
    @NotNull
    private final Material ingredient;
    private final float itemModelIndex;
    @NotNull
    private final Map<String, String> overrideArmorMaterials;
    @NotNull
    private final Component description;
    @Nullable
    private final Registry.TrimMaterialEntry registry;
    static final BinaryTagSerializer<TrimMaterial> REGISTRY_NBT_TYPE = BinaryTagSerializer.COMPOUND.map(tag -> {
        throw new UnsupportedOperationException("TrimMaterial is read-only");
    }, trimMaterial -> {
        CompoundBinaryTag.Builder overrideArmorMaterials = CompoundBinaryTag.builder();
        for (Map.Entry<String, String> entry : trimMaterial.overrideArmorMaterials().entrySet()) {
            overrideArmorMaterials.putString(entry.getKey(), entry.getValue());
        }
        return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("asset_name", trimMaterial.assetName())).put("ingredient", Material.NBT_TYPE.write(trimMaterial.ingredient()))).putFloat("item_model_index", trimMaterial.itemModelIndex())).put("override_armor_materials", (BinaryTag)overrideArmorMaterials.build())).put("description", BinaryTagSerializer.NBT_COMPONENT.write(trimMaterial.description()))).build();
    });

    TrimMaterialImpl(@NotNull String assetName, @NotNull Material ingredient, float itemModelIndex, @NotNull Map<String, String> overrideArmorMaterials, @NotNull Component description, @Nullable Registry.TrimMaterialEntry registry) {
        Check.argCondition(assetName == null || assetName.isEmpty(), "missing asset name");
        Check.argCondition(ingredient == null, "missing ingredient");
        Check.argCondition(overrideArmorMaterials == null, "missing override armor materials");
        Check.argCondition(description == null, "missing description");
        overrideArmorMaterials = Map.copyOf(overrideArmorMaterials);
        this.assetName = assetName;
        this.ingredient = ingredient;
        this.itemModelIndex = itemModelIndex;
        this.overrideArmorMaterials = overrideArmorMaterials;
        this.description = description;
        this.registry = registry;
    }

    TrimMaterialImpl(@NotNull Registry.TrimMaterialEntry registry) {
        this(registry.assetName(), registry.ingredient(), registry.itemModelIndex(), registry.overrideArmorMaterials(), registry.description(), registry);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TrimMaterialImpl.class, "assetName;ingredient;itemModelIndex;overrideArmorMaterials;description;registry", "assetName", "ingredient", "itemModelIndex", "overrideArmorMaterials", "description", "registry"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TrimMaterialImpl.class, "assetName;ingredient;itemModelIndex;overrideArmorMaterials;description;registry", "assetName", "ingredient", "itemModelIndex", "overrideArmorMaterials", "description", "registry"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TrimMaterialImpl.class, "assetName;ingredient;itemModelIndex;overrideArmorMaterials;description;registry", "assetName", "ingredient", "itemModelIndex", "overrideArmorMaterials", "description", "registry"}, this, o);
    }

    @Override
    @NotNull
    public String assetName() {
        return this.assetName;
    }

    @Override
    @NotNull
    public Material ingredient() {
        return this.ingredient;
    }

    @Override
    public float itemModelIndex() {
        return this.itemModelIndex;
    }

    @Override
    @NotNull
    public Map<String, String> overrideArmorMaterials() {
        return this.overrideArmorMaterials;
    }

    @Override
    @NotNull
    public Component description() {
        return this.description;
    }

    @Override
    @Nullable
    public Registry.TrimMaterialEntry registry() {
        return this.registry;
    }
}

