/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.color.Color;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.potion.CustomPotionEffect;
import net.minestom.server.potion.PotionType;
import net.minestom.server.utils.nbt.BinaryTagSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PotionContents(@Nullable PotionType potion, @Nullable RGBLike customColor, @NotNull List<CustomPotionEffect> customEffects, @Nullable String customName) {
    public static final PotionContents EMPTY = new PotionContents(null, null, List.of(), null);
    public static final NetworkBuffer.Type<PotionContents> NETWORK_TYPE = NetworkBufferTemplate.template(PotionType.NETWORK_TYPE.optional(), PotionContents::potion, Color.NETWORK_TYPE.optional(), PotionContents::customColor, CustomPotionEffect.NETWORK_TYPE.list(Short.MAX_VALUE), PotionContents::customEffects, NetworkBuffer.STRING.optional(), PotionContents::customName, PotionContents::new);
    public static final BinaryTagSerializer<PotionContents> NBT_TYPE = new BinaryTagSerializer<PotionContents>(){

        @Override
        @NotNull
        public BinaryTag write(@NotNull PotionContents value) {
            CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
            if (value.potion != null) {
                builder.put("potion", (BinaryTag)StringBinaryTag.stringBinaryTag((String)value.potion.name()));
            }
            if (value.customColor != null) {
                builder.put("custom_color", Color.NBT_TYPE.write(value.customColor));
            }
            if (!value.customEffects.isEmpty()) {
                ListBinaryTag.Builder effectsBuilder = ListBinaryTag.builder();
                for (CustomPotionEffect effect : value.customEffects) {
                    effectsBuilder.add(CustomPotionEffect.NBT_TYPE.write(effect));
                }
                builder.put("custom_effects", (BinaryTag)effectsBuilder.build());
            }
            if (value.customName != null) {
                builder.putString("custom_name", value.customName);
            }
            return builder.build();
        }

        @Override
        @NotNull
        public PotionContents read(@NotNull BinaryTag tag) {
            if (tag instanceof StringBinaryTag) {
                StringBinaryTag string = (StringBinaryTag)tag;
                return new PotionContents(PotionType.fromNamespaceId(string.value()), null, List.of(), null);
            }
            if (!(tag instanceof CompoundBinaryTag)) {
                return EMPTY;
            }
            CompoundBinaryTag compound = (CompoundBinaryTag)tag;
            PotionType potion = null;
            BinaryTag binaryTag = compound.get("potion");
            if (binaryTag instanceof StringBinaryTag) {
                StringBinaryTag potionTag = (StringBinaryTag)binaryTag;
                potion = PotionType.fromNamespaceId(potionTag.value());
            }
            Color customColor = null;
            BinaryTag binaryTag2 = compound.get("custom_color");
            if (binaryTag2 instanceof IntBinaryTag) {
                IntBinaryTag colorTag = (IntBinaryTag)binaryTag2;
                customColor = new Color(colorTag.value());
            }
            ArrayList<CustomPotionEffect> customEffects = new ArrayList<CustomPotionEffect>();
            ListBinaryTag customEffectsTag = compound.getList("custom_effects", BinaryTagTypes.COMPOUND);
            for (BinaryTag customEffectTag : customEffectsTag) {
                if (!(customEffectTag instanceof CompoundBinaryTag)) continue;
                CompoundBinaryTag customEffectCompound = (CompoundBinaryTag)customEffectTag;
                customEffects.add(CustomPotionEffect.NBT_TYPE.read((BinaryTag)customEffectCompound));
            }
            String customName = null;
            BinaryTag binaryTag3 = compound.get("custom_name");
            if (binaryTag3 instanceof StringBinaryTag) {
                StringBinaryTag customNameTag = (StringBinaryTag)binaryTag3;
                customName = customNameTag.value();
            }
            return new PotionContents(potion, customColor, customEffects, customName);
        }
    };

    public PotionContents(@Nullable PotionType potion, @Nullable RGBLike customColor, @NotNull List<CustomPotionEffect> customEffects, @Nullable String customName) {
        customEffects = List.copyOf(customEffects);
    }

    public PotionContents(@NotNull PotionType potion) {
        this(potion, null, List.of(), null);
    }

    public PotionContents(@NotNull PotionType potion, @NotNull RGBLike customColor) {
        this(potion, customColor, List.of(), null);
    }

    public PotionContents(@NotNull List<CustomPotionEffect> customEffects) {
        this(null, null, customEffects, null);
    }

    public PotionContents(@NotNull CustomPotionEffect customEffect) {
        this(null, null, List.of(customEffect), null);
    }

    public PotionContents(@Nullable PotionType potion, @Nullable RGBLike customColor, @NotNull List<CustomPotionEffect> customEffects) {
        this(potion, customColor, customEffects, null);
    }
}

