/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.listener;

import net.minestom.server.MinecraftServer;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.suggestion.Suggestion;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.client.play.ClientTabCompletePacket;
import net.minestom.server.network.packet.server.play.TabCompletePacket;
import org.jetbrains.annotations.Nullable;

public class TabCompleteListener {
    public static void listener(ClientTabCompletePacket packet, Player player) {
        String text = packet.text();
        Suggestion suggestion = TabCompleteListener.getSuggestion(player, text);
        if (suggestion != null) {
            player.sendPacket(new TabCompletePacket(packet.transactionId(), suggestion.getStart(), suggestion.getLength(), suggestion.getEntries().stream().map(suggestionEntry -> new TabCompletePacket.Match(suggestionEntry.getEntry(), suggestionEntry.getTooltip())).toList()));
        }
    }

    @Nullable
    public static Suggestion getSuggestion(CommandSender commandSender, String text) {
        if (((String)text).startsWith("/")) {
            text = ((String)text).substring(1);
        }
        if (((String)text).endsWith(" ")) {
            text = (String)text + "\u0000";
        }
        return MinecraftServer.getCommandManager().parseCommand(commandSender, (String)text).suggestion(commandSender);
    }
}

