/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.common;

import java.util.Arrays;
import java.util.Objects;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;

public record ClientPluginMessagePacket(@NotNull String channel, byte[] data) implements ClientPacket
{
    public static final NetworkBuffer.Type<ClientPluginMessagePacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.STRING, ClientPluginMessagePacket::channel, NetworkBuffer.RAW_BYTES, ClientPluginMessagePacket::data, ClientPluginMessagePacket::new);

    public ClientPluginMessagePacket(@NotNull String channel, byte[] data) {
        if (channel.length() > 256) {
            throw new IllegalArgumentException("Channel cannot be more than 256 characters long");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientPluginMessagePacket that = (ClientPluginMessagePacket)o;
        return Objects.deepEquals(this.data, that.data) && Objects.equals(this.channel, that.channel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.channel, Arrays.hashCode(this.data));
    }
}

