/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minestom.server.entity.Player;
import net.minestom.server.item.Material;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.play.DeclareRecipesPacket;
import net.minestom.server.recipe.Recipe;
import net.minestom.server.recipe.display.SlotDisplay;
import org.jetbrains.annotations.NotNull;

public final class RecipeManager {
    private final CachedPacket declareRecipesPacket = new CachedPacket(this::createDeclareRecipesPacket);
    private final Map<Recipe, Predicate<Player>> recipes = new ConcurrentHashMap<Recipe, Predicate<Player>>();

    public void addRecipe(@NotNull Recipe recipe, @NotNull Predicate<Player> predicate) {
        Predicate<Player> previous = this.recipes.put(recipe, predicate);
        if (previous == null) {
            this.declareRecipesPacket.invalidate();
        }
    }

    public void addRecipe(@NotNull Recipe recipe) {
        this.addRecipe(recipe, player -> true);
    }

    public void removeRecipe(@NotNull Recipe recipe) {
        if (this.recipes.remove(recipe) != null) {
            this.declareRecipesPacket.invalidate();
        }
    }

    public List<Recipe> consumeRecipes(Player player) {
        return this.recipes.entrySet().stream().filter(entry -> ((Predicate)entry.getValue()).test(player)).map(Map.Entry::getKey).toList();
    }

    @NotNull
    public Set<Recipe> getRecipes() {
        return this.recipes.keySet();
    }

    @NotNull
    public SendablePacket getDeclareRecipesPacket() {
        return this.declareRecipesPacket;
    }

    @NotNull
    private DeclareRecipesPacket createDeclareRecipesPacket() {
        return new DeclareRecipesPacket(Map.of(), List.of(new DeclareRecipesPacket.StonecutterRecipe(new Recipe.Ingredient(Material.DIAMOND), SlotDisplay.AnyFuel.INSTANCE)));
    }
}

