/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.component;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minestom.server.codec.Codec;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMapImpl;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.Unit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public sealed interface DataComponentMap
extends DataComponent.Holder
permits DataComponentMapImpl {
    @NotNull
    public static final DataComponentMap EMPTY = new DataComponentMapImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap(0));

    @NotNull
    public static Builder builder() {
        return new DataComponentMapImpl.BuilderImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap());
    }

    @NotNull
    public static PatchBuilder patchBuilder() {
        return new DataComponentMapImpl.PatchBuilderImpl((Int2ObjectMap<Object>)new Int2ObjectArrayMap());
    }

    @ApiStatus.Internal
    @NotNull
    public static NetworkBuffer.Type<DataComponentMap> networkType(@NotNull IntFunction<DataComponent<?>> idToType) {
        return new DataComponentMapImpl.NetworkTypeImpl(idToType, false, true);
    }

    @ApiStatus.Internal
    @NotNull
    public static Codec<DataComponentMap> codec(@NotNull IntFunction<DataComponent<?>> idToType, @NotNull Function<String, DataComponent<?>> nameToType) {
        return new DataComponentMapImpl.CodecImpl(idToType, nameToType, false);
    }

    @ApiStatus.Internal
    @NotNull
    public static NetworkBuffer.Type<DataComponentMap> patchNetworkType(@NotNull IntFunction<DataComponent<?>> idToType, boolean trusted) {
        return new DataComponentMapImpl.NetworkTypeImpl(idToType, true, trusted);
    }

    @ApiStatus.Internal
    @NotNull
    public static Codec<DataComponentMap> patchCodec(@NotNull IntFunction<DataComponent<?>> idToType, @NotNull Function<String, DataComponent<?>> nameToType) {
        return new DataComponentMapImpl.CodecImpl(idToType, nameToType, true);
    }

    @NotNull
    public static DataComponentMap diff(@NotNull DataComponentMap prototype, @NotNull DataComponentMap patch) {
        DataComponentMapImpl patchImpl = (DataComponentMapImpl)patch;
        if (patchImpl.components().isEmpty()) {
            return EMPTY;
        }
        DataComponentMapImpl protoImpl = (DataComponentMapImpl)prototype;
        Int2ObjectArrayMap diff = new Int2ObjectArrayMap(patchImpl.components());
        ObjectIterator iter = diff.int2ObjectEntrySet().fastIterator();
        while (iter.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter.next();
            Object protoComp = protoImpl.components().get(entry.getIntKey());
            if (entry.getValue() == null) {
                if (protoImpl.components().containsKey(entry.getIntKey())) continue;
                iter.remove();
                continue;
            }
            if (protoComp == null || !protoComp.equals(entry.getValue())) continue;
            iter.remove();
        }
        return new DataComponentMapImpl((Int2ObjectMap<Object>)diff);
    }

    public boolean isEmpty();

    public boolean has(@NotNull DataComponentMap var1, @NotNull DataComponent<?> var2);

    @Nullable
    public <T> T get(@NotNull DataComponentMap var1, @NotNull DataComponent<T> var2);

    @NotNull
    public <T> DataComponentMap set(@NotNull DataComponent<T> var1, @NotNull T var2);

    @NotNull
    default public DataComponentMap set(@NotNull DataComponent<Unit> component) {
        return this.set(component, Unit.INSTANCE);
    }

    @NotNull
    public DataComponentMap remove(@NotNull DataComponent<?> var1);

    @NotNull
    public Set<Map.Entry<DataComponent<?>, Object>> entrySet();

    @NotNull
    public Builder toBuilder();

    @NotNull
    public PatchBuilder toPatchBuilder();

    public static sealed interface PatchBuilder
    extends DataComponent.Holder
    permits DataComponentMapImpl.PatchBuilderImpl {
        @NotNull
        public <T> PatchBuilder set(@NotNull DataComponent<T> var1, @NotNull T var2);

        @NotNull
        default public PatchBuilder set(@NotNull DataComponent<Unit> component) {
            return this.set(component, Unit.INSTANCE);
        }

        @NotNull
        public PatchBuilder remove(@NotNull DataComponent<?> var1);

        @NotNull
        public DataComponentMap build();
    }

    public static sealed interface Builder
    extends DataComponent.Holder
    permits DataComponentMapImpl.BuilderImpl {
        @NotNull
        public <T> Builder set(@NotNull DataComponent<T> var1, @NotNull T var2);

        @NotNull
        default public Builder set(@NotNull DataComponent<Unit> component) {
            return this.set(component, Unit.INSTANCE);
        }

        @NotNull
        public DataComponentMap build();
    }
}

