/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public enum EquipmentSlot {
    MAIN_HAND(0, 0, "mainhand", false, -1),
    OFF_HAND(5, 1, "offhand", false, -1),
    BOOTS(1, 2, "feet", true, 44),
    LEGGINGS(2, 3, "legs", true, 43),
    CHESTPLATE(3, 4, "chest", true, 42),
    HELMET(4, 5, "head", true, 41),
    BODY(6, 6, "body", false, -1),
    SADDLE(7, 7, "saddle", false, -1);

    private static final List<EquipmentSlot> ARMORS;
    private static final Map<String, EquipmentSlot> BY_NBT_NAME;
    private static final Map<Integer, EquipmentSlot> BY_PROTOCOL_ID;
    private static final Map<Integer, EquipmentSlot> BY_LEGACY_PROTOCOL_ID;
    public static final NetworkBuffer.Type<EquipmentSlot> NETWORK_TYPE;
    public static final Codec<EquipmentSlot> CODEC;
    private final int protocolId;
    private final int legacyProtocolId;
    private final String nbtName;
    private final boolean armor;
    private final int armorSlot;

    @NotNull
    public static @NotNull List<@NotNull EquipmentSlot> armors() {
        return ARMORS;
    }

    @Deprecated
    @NotNull
    public static EquipmentSlot fromLegacyProtocolId(int legacyProtocolId) {
        EquipmentSlot slot = BY_LEGACY_PROTOCOL_ID.get(legacyProtocolId);
        if (slot != null) {
            return slot;
        }
        throw new IllegalStateException("Unexpected value: " + legacyProtocolId);
    }

    private EquipmentSlot(@NotNull int protocolId, int legacyProtocolId, String nbtName, boolean armor, int armorSlot) {
        this.protocolId = protocolId;
        this.legacyProtocolId = legacyProtocolId;
        this.nbtName = nbtName;
        this.armor = armor;
        this.armorSlot = armorSlot;
    }

    public int protocolId() {
        return this.protocolId;
    }

    @Deprecated
    public int legacyProtocolId() {
        return this.legacyProtocolId;
    }

    @NotNull
    public String nbtName() {
        return this.nbtName;
    }

    public boolean isHand() {
        return this == MAIN_HAND || this == OFF_HAND;
    }

    public boolean isArmor() {
        return this.armor;
    }

    public int armorSlot() {
        return this.armorSlot;
    }

    static {
        ARMORS = List.of(BOOTS, LEGGINGS, CHESTPLATE, HELMET);
        BY_NBT_NAME = Arrays.stream(EquipmentSlot.values()).collect(Collectors.toMap(EquipmentSlot::nbtName, slot -> slot));
        BY_PROTOCOL_ID = Arrays.stream(EquipmentSlot.values()).collect(Collectors.toMap(EquipmentSlot::protocolId, slot -> slot));
        BY_LEGACY_PROTOCOL_ID = Arrays.stream(EquipmentSlot.values()).collect(Collectors.toMap(EquipmentSlot::protocolId, slot -> slot));
        NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(BY_PROTOCOL_ID::get, EquipmentSlot::protocolId);
        CODEC = Codec.STRING.transform(BY_NBT_NAME::get, EquipmentSlot::nbtName);
    }
}

