/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minestom.server.codec.Codec;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public enum EquipmentSlotGroup implements Predicate<EquipmentSlot>
{
    ANY("any", EquipmentSlot.values()),
    MAIN_HAND("mainhand", EquipmentSlot.MAIN_HAND),
    OFF_HAND("offhand", EquipmentSlot.OFF_HAND),
    HAND("hand", EquipmentSlot.MAIN_HAND, EquipmentSlot.OFF_HAND),
    FEET("feet", EquipmentSlot.BOOTS),
    LEGS("legs", EquipmentSlot.LEGGINGS),
    CHEST("chest", EquipmentSlot.CHESTPLATE),
    HEAD("head", EquipmentSlot.HELMET),
    ARMOR("armor", EquipmentSlot.CHESTPLATE, EquipmentSlot.LEGGINGS, EquipmentSlot.BOOTS, EquipmentSlot.HELMET),
    BODY("body", EquipmentSlot.BODY),
    SADDLE("saddle", EquipmentSlot.SADDLE);

    private static final Map<String, EquipmentSlotGroup> BY_NBT_NAME;
    public static final NetworkBuffer.Type<EquipmentSlotGroup> NETWORK_TYPE;
    public static final Codec<EquipmentSlotGroup> CODEC;
    private final String nbtName;
    private final List<EquipmentSlot> equipmentSlots;

    private EquipmentSlotGroup(String nbtName, EquipmentSlot ... equipmentSlots) {
        this.equipmentSlots = List.of(equipmentSlots);
        this.nbtName = nbtName;
    }

    @NotNull
    public List<EquipmentSlot> equipmentSlots() {
        return this.equipmentSlots;
    }

    @NotNull
    public String nbtName() {
        return this.nbtName;
    }

    public boolean contains(@NotNull EquipmentSlot equipmentSlot) {
        return this.equipmentSlots.contains((Object)equipmentSlot);
    }

    @Override
    public boolean test(EquipmentSlot equipmentSlot) {
        return this.contains(equipmentSlot);
    }

    static {
        BY_NBT_NAME = Arrays.stream(EquipmentSlotGroup.values()).collect(Collectors.toMap(EquipmentSlotGroup::nbtName, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(EquipmentSlotGroup.class);
        CODEC = Codec.STRING.transform(BY_NBT_NAME::get, EquipmentSlotGroup::nbtName);
    }
}

