/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.water.fish;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minestom.server.codec.Codec;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.water.fish.AbstractFishMeta;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SalmonMeta
extends AbstractFishMeta {
    public SalmonMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @Deprecated
    @NotNull
    public Size getSize() {
        return Size.BY_ID.getOrDefault(this.metadata.get(MetadataDef.Salmon.SIZE), Size.MEDIUM);
    }

    @Deprecated
    public void setSize(@NotNull Size size) {
        this.metadata.set(MetadataDef.Salmon.SIZE, size.id());
    }

    @Override
    @Nullable
    protected <T> T get(@NotNull DataComponent<T> component) {
        if (component == DataComponents.SALMON_SIZE) {
            return (T)((Object)this.getSize());
        }
        return super.get(component);
    }

    @Override
    protected <T> void set(@NotNull DataComponent<T> component, @NotNull T value) {
        if (component == DataComponents.SALMON_SIZE) {
            this.setSize((Size)((Object)value));
        } else {
            super.set(component, value);
        }
    }

    public static enum Size {
        SMALL("small"),
        MEDIUM("medium"),
        LARGE("large");

        public static final NetworkBuffer.Type<Size> NETWORK_TYPE;
        public static final Codec<Size> CODEC;
        private static final Map<String, Size> BY_ID;
        private final String id;

        private Size(String id) {
            this.id = id;
        }

        @NotNull
        public String id() {
            return this.id;
        }

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Size.class);
            CODEC = Codec.Enum(Size.class);
            BY_ID = Arrays.stream(Size.values()).collect(Collectors.toMap(Size::id, size -> size));
        }
    }
}

