/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.Collection;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.component.DataComponents;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.MaterialImpl;
import net.minestom.server.item.Materials;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface Material
extends StaticProtocolObject,
Materials
permits MaterialImpl {
    public static final NetworkBuffer.Type<Material> NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(MaterialImpl::getId, Material::id);
    public static final Codec<Material> CODEC = Codec.STRING.transform(MaterialImpl::getSafe, StaticProtocolObject::name);

    @Override
    @Contract(pure=true)
    @NotNull
    public Registry.MaterialEntry registry();

    @Override
    @NotNull
    default public Key key() {
        return this.registry().key();
    }

    @Override
    default public int id() {
        return this.registry().id();
    }

    default public boolean isBlock() {
        return this.registry().block() != null;
    }

    default public @UnknownNullability Block block() {
        return this.registry().block();
    }

    @NotNull
    default public DataComponentMap prototype() {
        return this.registry().prototype();
    }

    default public boolean isArmor() {
        return this.registry().isArmor();
    }

    default public int maxStackSize() {
        return this.prototype().get(DataComponents.MAX_STACK_SIZE, 64);
    }

    @NotNull
    public static @NotNull Collection<@NotNull Material> values() {
        return MaterialImpl.values();
    }

    @Nullable
    public static Material fromKey(@NotNull String key) {
        return MaterialImpl.getSafe(key);
    }

    @Nullable
    public static Material fromKey(@NotNull Key key) {
        return Material.fromKey(key.asString());
    }

    @Nullable
    public static Material fromId(int id) {
        return MaterialImpl.getId(id);
    }
}

