/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;

public enum ItemRarity {
    COMMON,
    UNCOMMON,
    RARE,
    EPIC;

    private static final Map<String, ItemRarity> BY_ID;
    public static final NetworkBuffer.Type<ItemRarity> NETWORK_TYPE;
    public static final Codec<ItemRarity> CODEC;

    static {
        BY_ID = Arrays.stream(ItemRarity.values()).collect(Collectors.toMap(v -> v.name().toLowerCase(), Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(ItemRarity.class);
        CODEC = Codec.STRING.transform(BY_ID::get, v -> v.name().toLowerCase());
    }
}

