/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.enchant;

import java.util.List;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.item.enchant.LevelBasedValue;
import net.minestom.server.item.enchant.LocationEffect;
import net.minestom.server.potion.PotionEffect;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.ObjectSet;
import net.minestom.server.registry.Registries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public non-sealed interface EntityEffect
extends Enchantment.Effect {
    @NotNull
    public static final StructCodec<EntityEffect> CODEC = Codec.RegistryTaggedUnion(Registries::enchantmentEntityEffects, EntityEffect::codec, "type");

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<StructCodec<? extends EntityEffect>> createDefaultRegistry() {
        DynamicRegistry<StructCodec<? extends EntityEffect>> registry = DynamicRegistry.create("minestom:enchantment_value_effect");
        registry.register("all_of", AllOf.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("apply_mob_effect", ApplyPotionEffect.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("change_item_damage", ChangeItemDamage.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("damage_entity", DamageEntity.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("explode", Explode.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("ignite", Ignite.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("play_sound", PlaySound.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("replace_block", ReplaceBlock.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("replace_disk", ReplaceDisc.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("run_function", RunFunction.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("set_block_properties", SetBlockProperties.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("spawn_particles", SpawnParticles.CODEC, DataPack.MINECRAFT_CORE);
        registry.register("summon_entity", SummonEntity.CODEC, DataPack.MINECRAFT_CORE);
        return registry;
    }

    @NotNull
    public StructCodec<? extends EntityEffect> codec();

    public record AllOf(@NotNull List<EntityEffect> effect) implements EntityEffect
    {
        public static final StructCodec<AllOf> CODEC = StructCodec.struct("effects", CODEC.list(), AllOf::effect, AllOf::new);

        public AllOf(@NotNull List<EntityEffect> effect) {
            effect = List.copyOf(effect);
        }

        @NotNull
        public StructCodec<AllOf> codec() {
            return CODEC;
        }
    }

    public record ApplyPotionEffect(@NotNull ObjectSet<PotionEffect> toApply, @NotNull LevelBasedValue minDuration, @NotNull LevelBasedValue maxDuration, @NotNull LevelBasedValue minAmplifier, @NotNull LevelBasedValue maxAmplifier) implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<ApplyPotionEffect> CODEC = StructCodec.struct("to_apply", ObjectSet.codec(Tag.BasicType.POTION_EFFECTS), ApplyPotionEffect::toApply, "min_duration", LevelBasedValue.CODEC, ApplyPotionEffect::minDuration, "max_duration", LevelBasedValue.CODEC, ApplyPotionEffect::maxDuration, "min_amplifier", LevelBasedValue.CODEC, ApplyPotionEffect::minAmplifier, "max_amplifier", LevelBasedValue.CODEC, ApplyPotionEffect::maxAmplifier, ApplyPotionEffect::new);

        @NotNull
        public StructCodec<ApplyPotionEffect> codec() {
            return CODEC;
        }
    }

    public record ChangeItemDamage(@NotNull LevelBasedValue amount) implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<ChangeItemDamage> CODEC = StructCodec.struct("amount", LevelBasedValue.CODEC, ChangeItemDamage::amount, ChangeItemDamage::new);

        @NotNull
        public StructCodec<ChangeItemDamage> codec() {
            return CODEC;
        }
    }

    public record DamageEntity(@NotNull DynamicRegistry.Key<DamageType> damageType, @NotNull LevelBasedValue minDamage, @NotNull LevelBasedValue maxDamage) implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<DamageEntity> CODEC = StructCodec.struct("damage_type", DamageType.CODEC, DamageEntity::damageType, "min_damage", LevelBasedValue.CODEC, DamageEntity::minDamage, "max_damage", LevelBasedValue.CODEC, DamageEntity::maxDamage, DamageEntity::new);

        @NotNull
        public StructCodec<DamageEntity> codec() {
            return CODEC;
        }
    }

    public record Explode() implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<Explode> CODEC = StructCodec.struct(Explode::new);

        @NotNull
        public StructCodec<Explode> codec() {
            return CODEC;
        }
    }

    public record Ignite(@NotNull LevelBasedValue duration) implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<Ignite> CODEC = StructCodec.struct("duration", LevelBasedValue.CODEC, Ignite::duration, Ignite::new);

        @NotNull
        public StructCodec<Ignite> codec() {
            return CODEC;
        }
    }

    public record PlaySound() implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<PlaySound> CODEC = StructCodec.struct(PlaySound::new);

        @NotNull
        public StructCodec<PlaySound> codec() {
            return CODEC;
        }
    }

    public record ReplaceBlock() implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<ReplaceBlock> CODEC = StructCodec.struct(ReplaceBlock::new);

        @NotNull
        public StructCodec<ReplaceBlock> codec() {
            return CODEC;
        }
    }

    public record ReplaceDisc() implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<ReplaceDisc> CODEC = StructCodec.struct(ReplaceDisc::new);

        @NotNull
        public StructCodec<ReplaceDisc> codec() {
            return CODEC;
        }
    }

    public record RunFunction(@NotNull String function) implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<RunFunction> CODEC = StructCodec.struct("function", Codec.STRING, RunFunction::function, RunFunction::new);

        @NotNull
        public StructCodec<RunFunction> codec() {
            return CODEC;
        }
    }

    public record SetBlockProperties() implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<SetBlockProperties> CODEC = StructCodec.struct(SetBlockProperties::new);

        @NotNull
        public StructCodec<SetBlockProperties> codec() {
            return CODEC;
        }
    }

    public record SpawnParticles() implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<SpawnParticles> CODEC = StructCodec.struct(SpawnParticles::new);

        @NotNull
        public StructCodec<SpawnParticles> codec() {
            return CODEC;
        }
    }

    public record SummonEntity() implements EntityEffect,
    LocationEffect
    {
        public static final StructCodec<SummonEntity> CODEC = StructCodec.struct(SummonEntity::new);

        @NotNull
        public StructCodec<SummonEntity> codec() {
            return CODEC;
        }
    }
}

