/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferImpl;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryTranscoder;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.nbt.BinaryTagReader;
import net.minestom.server.utils.nbt.BinaryTagWriter;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

interface NetworkBufferTypeImpl<T>
extends NetworkBuffer.Type<T> {
    public static final int SEGMENT_BITS = 127;
    public static final int CONTINUE_BIT = 128;

    public static <T> long sizeOf(NetworkBuffer.Type<T> type, T value, Registries registries) {
        NetworkBufferImpl buffer = NetworkBufferImpl.dummy(registries);
        type.write(buffer, value);
        return buffer.writeIndex();
    }

    public record IOUTF8StringType() implements NetworkBufferTypeImpl<String>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, String value) {
            char c;
            int i;
            int strlen;
            int utflen = strlen = value.length();
            for (int i2 = 0; i2 < strlen; ++i2) {
                char c2 = value.charAt(i2);
                if (c2 < '\u0080' && c2 != '\u0000') continue;
                utflen += c2 >= '\u0800' ? 2 : 1;
            }
            if (utflen > 65535 || utflen < strlen) {
                throw new RuntimeException("UTF-8 string too long");
            }
            buffer.write(NetworkBuffer.SHORT, (short)utflen);
            buffer.ensureWritable(utflen);
            NetworkBufferImpl impl = (NetworkBufferImpl)buffer;
            for (i = 0; i < strlen && (c = value.charAt(i)) < '\u0080' && c != '\u0000'; ++i) {
                impl._putByte(buffer.writeIndex(), (byte)c);
                impl.advanceWrite(1L);
            }
            while (i < strlen) {
                c = value.charAt(i);
                if (c < '\u0080' && c != '\u0000') {
                    impl._putByte(buffer.writeIndex(), (byte)c);
                    impl.advanceWrite(1L);
                } else if (c >= '\u0800') {
                    impl._putByte(buffer.writeIndex(), (byte)(0xE0 | c >> 12 & 0xF));
                    impl._putByte(buffer.writeIndex() + 1L, (byte)(0x80 | c >> 6 & 0x3F));
                    impl._putByte(buffer.writeIndex() + 2L, (byte)(0x80 | c >> 0 & 0x3F));
                    impl.advanceWrite(3L);
                } else {
                    impl._putByte(buffer.writeIndex(), (byte)(0xC0 | c >> 6 & 0x1F));
                    impl._putByte(buffer.writeIndex() + 1L, (byte)(0x80 | c >> 0 & 0x3F));
                    impl.advanceWrite(2L);
                }
                ++i;
            }
        }

        @Override
        public String read(@NotNull NetworkBuffer buffer) {
            int c;
            int count;
            int utflen = buffer.read(NetworkBuffer.UNSIGNED_SHORT);
            if (buffer.readableBytes() < (long)utflen) {
                throw new IllegalArgumentException("Invalid String size.");
            }
            byte[] bytearr = buffer.read(NetworkBuffer.FixedRawBytes(utflen));
            char[] chararr = new char[utflen];
            int chararr_count = 0;
            for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
                chararr[chararr_count++] = (char)c;
            }
            block8: while (count < utflen) {
                c = bytearr[count] & 0xFF;
                try {
                    switch (c >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            ++count;
                            chararr[chararr_count++] = (char)c;
                            continue block8;
                        }
                        case 12: 
                        case 13: {
                            if ((count += 2) > utflen) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            byte char2 = bytearr[count - 1];
                            if ((char2 & 0xC0) != 128) {
                                throw new UTFDataFormatException("malformed input around byte " + count);
                            }
                            chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                            continue block8;
                        }
                        case 14: {
                            if ((count += 3) > utflen) {
                                throw new UTFDataFormatException("malformed input: partial character at end");
                            }
                            byte char2 = bytearr[count - 2];
                            byte char3 = bytearr[count - 1];
                            if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                                throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                            }
                            chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                            continue block8;
                        }
                    }
                    throw new UTFDataFormatException("malformed input around byte " + count);
                }
                catch (UTFDataFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            return new String(chararr, 0, chararr_count);
        }
    }

    public record RegistryTypeType<T>(@NotNull Function<Registries, DynamicRegistry<T>> selector, boolean holder) implements NetworkBufferTypeImpl<DynamicRegistry.Key<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, DynamicRegistry.Key<T> value) {
            Registries registries = NetworkBufferImpl.impl((NetworkBuffer)buffer).registries;
            Check.stateCondition(registries == null, "Buffer does not have registries");
            DynamicRegistry<T> registry = this.selector.apply(registries);
            int id = registry.getId(value) + (this.holder ? 1 : 0);
            Check.argCondition(id == -1, "Key is not registered: {0} > {1}", registry, value);
            buffer.write(NetworkBuffer.VAR_INT, id);
        }

        @Override
        public DynamicRegistry.Key<T> read(@NotNull NetworkBuffer buffer) {
            Registries registries = NetworkBufferImpl.impl((NetworkBuffer)buffer).registries;
            Check.stateCondition(registries == null, "Buffer does not have registries");
            DynamicRegistry<int> registry = this.selector.apply(registries);
            int id = buffer.read(NetworkBuffer.VAR_INT) + (this.holder ? -1 : 0);
            DynamicRegistry.Key<int> key = registry.getKey(id);
            Check.argCondition(key == null, "No such ID in registry: {0} > {1}", registry, id);
            return key;
        }
    }

    public record UnionType<K, T>(@NotNull NetworkBuffer.Type<K> keyType, @NotNull Function<T, K> keyFunc, @NotNull Function<K, NetworkBuffer.Type<T>> serializers) implements NetworkBufferTypeImpl<T>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, T value) {
            K key = this.keyFunc.apply(value);
            buffer.write(this.keyType, key);
            NetworkBuffer.Type<T> serializer = this.serializers.apply(key);
            if (serializer == null) {
                throw new UnsupportedOperationException("Unrecognized type: " + String.valueOf(key));
            }
            serializer.write(buffer, value);
        }

        @Override
        public T read(@NotNull NetworkBuffer buffer) {
            K key = buffer.read(this.keyType);
            NetworkBuffer.Type<T> serializer = this.serializers.apply(key);
            if (serializer == null) {
                throw new UnsupportedOperationException("Unrecognized type: " + String.valueOf(key));
            }
            return serializer.read(buffer);
        }
    }

    public record SetType<T>(@NotNull NetworkBuffer.Type<T> parent, int maxSize) implements NetworkBufferTypeImpl<Set<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Set<T> values) {
            if (values == null) {
                buffer.write(NetworkBuffer.BYTE, (byte)0);
                return;
            }
            buffer.write(NetworkBuffer.VAR_INT, values.size());
            for (T value : values) {
                buffer.write(this.parent, value);
            }
        }

        @Override
        public Set<T> read(@NotNull NetworkBuffer buffer) {
            int size = buffer.read(NetworkBuffer.VAR_INT);
            Check.argCondition(size > this.maxSize, "Collection size ({0}) is higher than the maximum allowed size ({1})", size, this.maxSize);
            Object[] values = new Object[size];
            for (int i = 0; i < size; ++i) {
                values[i] = buffer.read(this.parent);
            }
            return Set.of(values);
        }
    }

    public record ListType<T>(@NotNull NetworkBuffer.Type<T> parent, int maxSize) implements NetworkBufferTypeImpl<List<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, List<T> values) {
            if (values == null) {
                buffer.write(NetworkBuffer.BYTE, (byte)0);
                return;
            }
            buffer.write(NetworkBuffer.VAR_INT, values.size());
            for (T value : values) {
                buffer.write(this.parent, value);
            }
        }

        @Override
        public List<T> read(@NotNull NetworkBuffer buffer) {
            int size = buffer.read(NetworkBuffer.VAR_INT);
            Check.argCondition(size > this.maxSize, "Collection size ({0}) is higher than the maximum allowed size ({1})", size, this.maxSize);
            Object[] values = new Object[size];
            for (int i = 0; i < size; ++i) {
                values[i] = buffer.read(this.parent);
            }
            return List.of(values);
        }
    }

    public record MapType<K, V>(@NotNull NetworkBuffer.Type<K> parent, @NotNull NetworkBuffer.Type<V> valueType, int maxSize) implements NetworkBufferTypeImpl<Map<K, V>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Map<K, V> map) {
            buffer.write(NetworkBuffer.VAR_INT, map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                buffer.write(this.parent, entry.getKey());
                buffer.write(this.valueType, entry.getValue());
            }
        }

        @Override
        public Map<K, V> read(@NotNull NetworkBuffer buffer) {
            int size = buffer.read(NetworkBuffer.VAR_INT);
            Check.argCondition(size > this.maxSize, "Map size ({0}) is higher than the maximum allowed size ({1})", size, this.maxSize);
            Object[] keys = new Object[size];
            Object[] values = new Object[size];
            for (int i = 0; i < size; ++i) {
                keys[i] = buffer.read(this.parent);
                values[i] = buffer.read(this.valueType);
            }
            return Map.copyOf(new Object2ObjectArrayMap(keys, values, size));
        }
    }

    public record TransformType<T, S>(@NotNull NetworkBuffer.Type<T> parent, @NotNull Function<T, S> to, @NotNull Function<S, T> from) implements NetworkBufferTypeImpl<S>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, S value) {
            this.parent.write(buffer, this.from.apply(value));
        }

        @Override
        public S read(@NotNull NetworkBuffer buffer) {
            return this.to.apply(this.parent.read(buffer));
        }
    }

    public record TypedNbtType<T>(@NotNull Codec<T> nbtType) implements NetworkBufferTypeImpl<T>
    {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void write(@NotNull NetworkBuffer buffer, T value) {
            String message;
            Result<BinaryTag> result;
            Registries registries = NetworkBufferImpl.impl((NetworkBuffer)buffer).registries;
            Check.stateCondition(registries == null, "Buffer does not have registries");
            Result<BinaryTag> result2 = result = this.nbtType.encode(new RegistryTranscoder<BinaryTag>(Transcoder.NBT, registries), value);
            Objects.requireNonNull(result2);
            Result<BinaryTag> result3 = result2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, result3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    BinaryTag tag;
                    Result.Ok ok = (Result.Ok)result3;
                    try {
                        BinaryTag binaryTag;
                        tag = binaryTag = (BinaryTag)ok.value();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    buffer.write(NetworkBuffer.NBT, tag);
                    return;
                }
                case 1: 
            }
            Result.Error error = (Result.Error)result3;
            {
                String string;
                message = string = error.message();
            }
            throw new IllegalArgumentException("Invalid NBT tag: " + message);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T read(@NotNull NetworkBuffer buffer) {
            String message;
            Result result;
            Registries registries = NetworkBufferImpl.impl((NetworkBuffer)buffer).registries;
            Check.stateCondition(registries == null, "Buffer does not have registries");
            Result result2 = result = this.nbtType.decode(new RegistryTranscoder<BinaryTag>(Transcoder.NBT, registries), buffer.read(NetworkBuffer.NBT));
            Objects.requireNonNull(result2);
            Result result3 = result2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, result3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Result.Ok ok = (Result.Ok)result3;
                    try {
                        Object t;
                        Object value = t = ok.value();
                        return value;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: 
            }
            Result.Error error = (Result.Error)result3;
            {
                String string;
                message = string = error.message();
            }
            throw new IllegalArgumentException("Invalid NBT tag: " + message);
        }
    }

    public static final class LazyType<T>
    implements NetworkBufferTypeImpl<T> {
        @NotNull
        private final @NotNull Supplier<@NotNull NetworkBuffer.Type<T>> supplier;
        private NetworkBuffer.Type<T> type;

        public LazyType(@NotNull @NotNull Supplier<@NotNull NetworkBuffer.Type<T>> supplier) {
            this.supplier = supplier;
        }

        @Override
        public void write(@NotNull NetworkBuffer buffer, T value) {
            if (this.type == null) {
                this.type = this.supplier.get();
            }
            this.type.write(buffer, value);
        }

        @Override
        public T read(@NotNull NetworkBuffer buffer) {
            if (this.type == null) {
                this.type = this.supplier.get();
            }
            return null;
        }
    }

    public record OptionalType<T>(@NotNull NetworkBuffer.Type<T> parent) implements NetworkBufferTypeImpl<T>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, T value) {
            buffer.write(NetworkBuffer.BOOLEAN, value != null);
            if (value != null) {
                buffer.write(this.parent, value);
            }
        }

        @Override
        public T read(@NotNull NetworkBuffer buffer) {
            return buffer.read(NetworkBuffer.BOOLEAN) != false ? (T)buffer.read(this.parent) : null;
        }
    }

    public record FixedBitSetType(int length) implements NetworkBufferTypeImpl<BitSet>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, BitSet value) {
            int setLength = value.length();
            if (setLength > this.length) {
                throw new IllegalArgumentException("BitSet is larger than expected size (" + setLength + ">" + this.length + ")");
            }
            byte[] array = value.toByteArray();
            buffer.write(NetworkBuffer.RAW_BYTES, array);
        }

        @Override
        public BitSet read(@NotNull NetworkBuffer buffer) {
            byte[] array = buffer.read(NetworkBuffer.FixedRawBytes((this.length + 7) / 8));
            return BitSet.valueOf(array);
        }
    }

    public record EnumSetType<E extends Enum<E>>(@NotNull Class<E> enumType, E[] values) implements NetworkBufferTypeImpl<EnumSet<E>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, EnumSet<E> value) {
            BitSet bitSet = new BitSet(this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                bitSet.set(i, value.contains(this.values[i]));
            }
            byte[] array = bitSet.toByteArray();
            buffer.write(NetworkBuffer.RAW_BYTES, array);
        }

        @Override
        public EnumSet<E> read(@NotNull NetworkBuffer buffer) {
            byte[] array = buffer.read(NetworkBuffer.FixedRawBytes((this.values.length + 7) / 8));
            BitSet bitSet = BitSet.valueOf(array);
            EnumSet<E> enumSet = EnumSet.noneOf(this.enumType);
            for (int i = 0; i < this.values.length; ++i) {
                if (!bitSet.get(i)) continue;
                enumSet.add(this.values[i]);
            }
            return enumSet;
        }
    }

    public record QuaternionType() implements NetworkBufferTypeImpl<float[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, float[] value) {
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[0]));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[1]));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[2]));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value[3]));
        }

        @Override
        public float[] read(@NotNull NetworkBuffer buffer) {
            float x = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float y = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float z = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float w = buffer.read(NetworkBuffer.FLOAT).floatValue();
            return new float[]{x, y, z, w};
        }
    }

    public record Vector3BType() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            buffer.write(NetworkBuffer.BYTE, (byte)value.x());
            buffer.write(NetworkBuffer.BYTE, (byte)value.y());
            buffer.write(NetworkBuffer.BYTE, (byte)value.z());
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            byte x = buffer.read(NetworkBuffer.BYTE);
            byte y = buffer.read(NetworkBuffer.BYTE);
            byte z = buffer.read(NetworkBuffer.BYTE);
            return new Vec(x, y, z);
        }
    }

    public record Vector3IType() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            buffer.write(NetworkBuffer.VAR_INT, (int)value.x());
            buffer.write(NetworkBuffer.VAR_INT, (int)value.y());
            buffer.write(NetworkBuffer.VAR_INT, (int)value.z());
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            int x = buffer.read(NetworkBuffer.VAR_INT);
            int y = buffer.read(NetworkBuffer.VAR_INT);
            int z = buffer.read(NetworkBuffer.VAR_INT);
            return new Vec(x, y, z);
        }
    }

    public record Vector3DType() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            buffer.write(NetworkBuffer.DOUBLE, value.x());
            buffer.write(NetworkBuffer.DOUBLE, value.y());
            buffer.write(NetworkBuffer.DOUBLE, value.z());
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            double x = buffer.read(NetworkBuffer.DOUBLE);
            double y = buffer.read(NetworkBuffer.DOUBLE);
            double z = buffer.read(NetworkBuffer.DOUBLE);
            return new Vec(x, y, z);
        }
    }

    public record Vector3Type() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf((float)value.x()));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf((float)value.y()));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf((float)value.z()));
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            float x = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float y = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float z = buffer.read(NetworkBuffer.FLOAT).floatValue();
            return new Vec(x, y, z);
        }
    }

    public record VarLongArrayType() implements NetworkBufferTypeImpl<long[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, long[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            for (long l : value) {
                buffer.write(NetworkBuffer.VAR_LONG, l);
            }
        }

        @Override
        public long[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            long[] longs = new long[length];
            for (int i = 0; i < length; ++i) {
                longs[i] = buffer.read(NetworkBuffer.VAR_LONG);
            }
            return longs;
        }
    }

    public record VarIntArrayType() implements NetworkBufferTypeImpl<int[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, int[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            for (int i : value) {
                buffer.write(NetworkBuffer.VAR_INT, i);
            }
        }

        @Override
        public int[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            int[] ints = new int[length];
            for (int i = 0; i < length; ++i) {
                ints[i] = buffer.read(NetworkBuffer.VAR_INT);
            }
            return ints;
        }
    }

    public record LongArrayType() implements NetworkBufferTypeImpl<long[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, long[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            for (long l : value) {
                buffer.write(NetworkBuffer.LONG, l);
            }
        }

        @Override
        public long[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            long[] longs = new long[length];
            for (int i = 0; i < length; ++i) {
                longs[i] = buffer.read(NetworkBuffer.LONG);
            }
            return longs;
        }
    }

    public record ByteArrayType() implements NetworkBufferTypeImpl<byte[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, byte[] value) {
            buffer.write(NetworkBuffer.VAR_INT, value.length);
            buffer.write(NetworkBuffer.RAW_BYTES, value);
        }

        @Override
        public byte[] read(@NotNull NetworkBuffer buffer) {
            int length = buffer.read(NetworkBuffer.VAR_INT);
            if (length == 0) {
                return new byte[0];
            }
            long remaining = buffer.readableBytes();
            Check.argCondition((long)length > remaining, "String is too long (length: {0}, readable: {1})", length, remaining);
            return buffer.read(NetworkBuffer.FixedRawBytes(length));
        }
    }

    public record PosType() implements NetworkBufferTypeImpl<Pos>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Pos value) {
            buffer.write(NetworkBuffer.DOUBLE, value.x());
            buffer.write(NetworkBuffer.DOUBLE, value.y());
            buffer.write(NetworkBuffer.DOUBLE, value.z());
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.yaw()));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.pitch()));
        }

        @Override
        public Pos read(@NotNull NetworkBuffer buffer) {
            double x = buffer.read(NetworkBuffer.DOUBLE);
            double y = buffer.read(NetworkBuffer.DOUBLE);
            double z = buffer.read(NetworkBuffer.DOUBLE);
            float yaw = buffer.read(NetworkBuffer.FLOAT).floatValue();
            float pitch = buffer.read(NetworkBuffer.FLOAT).floatValue();
            return new Pos(x, y, z, yaw, pitch);
        }
    }

    public record UUIDType() implements NetworkBufferTypeImpl<UUID>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, UUID value) {
            buffer.write(NetworkBuffer.LONG, value.getMostSignificantBits());
            buffer.write(NetworkBuffer.LONG, value.getLeastSignificantBits());
        }

        @Override
        public UUID read(@NotNull NetworkBuffer buffer) {
            long mostSignificantBits = buffer.read(NetworkBuffer.LONG);
            long leastSignificantBits = buffer.read(NetworkBuffer.LONG);
            return new UUID(mostSignificantBits, leastSignificantBits);
        }
    }

    public record JsonComponentType() implements NetworkBufferTypeImpl<Component>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Component value) {
            String json = (String)GsonComponentSerializer.gson().serialize(value);
            buffer.write(NetworkBuffer.STRING, json);
        }

        @Override
        public Component read(@NotNull NetworkBuffer buffer) {
            String json = buffer.read(NetworkBuffer.STRING);
            return GsonComponentSerializer.gson().deserialize((Object)json);
        }
    }

    public record BlockPositionType() implements NetworkBufferTypeImpl<Point>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Point value) {
            int blockX = value.blockX();
            int blockY = value.blockY();
            int blockZ = value.blockZ();
            long longPos = ((long)blockX & 0x3FFFFFFL) << 38 | ((long)blockZ & 0x3FFFFFFL) << 12 | (long)blockY & 0xFFFL;
            buffer.write(NetworkBuffer.LONG, longPos);
        }

        @Override
        public Point read(@NotNull NetworkBuffer buffer) {
            long value = buffer.read(NetworkBuffer.LONG);
            int x = (int)(value >> 38);
            int y = (int)(value << 52 >> 52);
            int z = (int)(value << 26 >> 38);
            return new Vec(x, y, z);
        }
    }

    public record NbtType() implements NetworkBufferTypeImpl<BinaryTag>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, BinaryTag value) {
            BinaryTagWriter nbtWriter = NetworkBufferImpl.impl(buffer).nbtWriter();
            try {
                nbtWriter.writeNameless(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public BinaryTag read(@NotNull NetworkBuffer buffer) {
            BinaryTagReader nbtReader = NetworkBufferImpl.impl(buffer).nbtReader();
            try {
                return nbtReader.readNameless();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public record StringTerminatedType() implements NetworkBufferTypeImpl<String>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, String value) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            byte[] terminated = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, terminated, 0, bytes.length);
            terminated[terminated.length - 1] = 0;
            buffer.write(NetworkBuffer.RAW_BYTES, terminated);
        }

        @Override
        public String read(@NotNull NetworkBuffer buffer) {
            byte b;
            ByteArrayList bytes = new ByteArrayList();
            while ((b = buffer.read(NetworkBuffer.BYTE).byteValue()) != 0) {
                bytes.add(b);
            }
            return new String(bytes.elements(), StandardCharsets.UTF_8);
        }
    }

    public record StringType() implements NetworkBufferTypeImpl<String>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, String value) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            buffer.write(NetworkBuffer.BYTE_ARRAY, bytes);
        }

        @Override
        public String read(@NotNull NetworkBuffer buffer) {
            byte[] bytes = buffer.read(NetworkBuffer.BYTE_ARRAY);
            return new String(bytes, StandardCharsets.UTF_8);
        }
    }

    public record RawBytesType(int length) implements NetworkBufferTypeImpl<byte[]>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, byte[] value) {
            if (this.length != -1 && value.length != this.length) {
                throw new IllegalArgumentException("Invalid length: " + value.length + " != " + this.length);
            }
            int length = value.length;
            if (length == 0) {
                return;
            }
            buffer.ensureWritable(length);
            NetworkBufferImpl.impl(buffer)._putBytes(buffer.writeIndex(), value);
            buffer.advanceWrite(length);
        }

        @Override
        public byte[] read(@NotNull NetworkBuffer buffer) {
            long length = buffer.readableBytes();
            if (this.length != -1) {
                length = Math.min(length, (long)this.length);
            }
            if (length == 0L) {
                return new byte[0];
            }
            assert (length > 0L) : "Invalid remaining: " + length;
            int arrayLength = Math.toIntExact(length);
            byte[] bytes = new byte[arrayLength];
            NetworkBufferImpl.impl(buffer)._getBytes(buffer.readIndex(), bytes);
            buffer.advanceRead(arrayLength);
            return bytes;
        }
    }

    public record VarLongType() implements NetworkBufferTypeImpl<Long>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Long value) {
            buffer.ensureWritable(10L);
            int size = 0;
            while (true) {
                if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    NetworkBufferImpl.impl(buffer)._putByte(buffer.writeIndex() + (long)size, (byte)value.intValue());
                    buffer.advanceWrite(size + 1);
                    return;
                }
                NetworkBufferImpl.impl(buffer)._putByte(buffer.writeIndex() + (long)size, (byte)(value & 0x7FL | 0x80L));
                ++size;
                value = value >>> 7;
            }
        }

        @Override
        public Long read(@NotNull NetworkBuffer buffer) {
            long value;
            int length;
            block1: {
                length = 0;
                value = 0L;
                int position = 0;
                do {
                    byte currentByte = NetworkBufferImpl.impl(buffer)._getByte(buffer.readIndex() + (long)length);
                    ++length;
                    value |= (long)(currentByte & 0x7F) << position;
                    if ((currentByte & 0x80) == 0) break block1;
                } while ((position += 7) < 64);
                throw new RuntimeException("VarLong is too big");
            }
            buffer.advanceRead(length);
            return value;
        }
    }

    public record VarInt3Type() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer boxed) {
            int value = boxed;
            Check.argCondition(value < 0 || value >= 0x200000, "VarInt3 out of bounds: {0}", value);
            buffer.ensureWritable(3L);
            long startIndex = buffer.writeIndex();
            NetworkBufferImpl impl = NetworkBufferImpl.impl(buffer);
            impl._putByte(startIndex, (byte)(value & 0x7F | 0x80));
            impl._putByte(startIndex + 1L, (byte)(value >>> 7 & 0x7F | 0x80));
            impl._putByte(startIndex + 2L, (byte)(value >>> 14));
            buffer.advanceWrite(3L);
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            return buffer.read(NetworkBuffer.VAR_INT);
        }
    }

    public record OptionalVarIntType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, @Nullable Integer value) {
            buffer.write(NetworkBuffer.VAR_INT, value == null ? 0 : value + 1);
        }

        @Override
        @Nullable
        public Integer read(@NotNull NetworkBuffer buffer) {
            int value = buffer.read(NetworkBuffer.VAR_INT);
            return value == 0 ? null : Integer.valueOf(value - 1);
        }
    }

    public record VarIntType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer boxed) {
            buffer.ensureWritable(5L);
            long index = buffer.writeIndex();
            int value = boxed;
            NetworkBufferImpl nio = NetworkBufferImpl.impl(buffer);
            while (true) {
                if ((value & 0xFFFFFF80) == 0) {
                    nio._putByte(index++, (byte)value);
                    buffer.advanceWrite(index - buffer.writeIndex());
                    return;
                }
                nio._putByte(index++, (byte)((byte)(value & 0x7F) | 0x80));
                value >>>= 7;
            }
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            long index = buffer.readIndex();
            int result = 0;
            int shift = 0;
            while (true) {
                byte b = NetworkBufferImpl.impl(buffer)._getByte(index++);
                result |= (b & 0x7F) << shift;
                if (b >= 0) {
                    buffer.advanceRead(index - buffer.readIndex());
                    return result;
                }
                shift += 7;
            }
        }
    }

    public record DoubleType() implements NetworkBufferTypeImpl<Double>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Double value) {
            buffer.ensureWritable(8L);
            NetworkBufferImpl.impl(buffer)._putDouble(buffer.writeIndex(), value);
            buffer.advanceWrite(8L);
        }

        @Override
        public Double read(@NotNull NetworkBuffer buffer) {
            double value = NetworkBufferImpl.impl(buffer)._getDouble(buffer.readIndex());
            buffer.advanceRead(8L);
            return value;
        }
    }

    public record FloatType() implements NetworkBufferTypeImpl<Float>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Float value) {
            buffer.ensureWritable(4L);
            NetworkBufferImpl.impl(buffer)._putFloat(buffer.writeIndex(), value.floatValue());
            buffer.advanceWrite(4L);
        }

        @Override
        public Float read(@NotNull NetworkBuffer buffer) {
            float value = NetworkBufferImpl.impl(buffer)._getFloat(buffer.readIndex());
            buffer.advanceRead(4L);
            return Float.valueOf(value);
        }
    }

    public record LongType() implements NetworkBufferTypeImpl<Long>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Long value) {
            buffer.ensureWritable(8L);
            NetworkBufferImpl.impl(buffer)._putLong(buffer.writeIndex(), value);
            buffer.advanceWrite(8L);
        }

        @Override
        public Long read(@NotNull NetworkBuffer buffer) {
            long value = NetworkBufferImpl.impl(buffer)._getLong(buffer.readIndex());
            buffer.advanceRead(8L);
            return value;
        }
    }

    public record IntType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer value) {
            buffer.ensureWritable(4L);
            NetworkBufferImpl.impl(buffer)._putInt(buffer.writeIndex(), value);
            buffer.advanceWrite(4L);
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            int value = NetworkBufferImpl.impl(buffer)._getInt(buffer.readIndex());
            buffer.advanceRead(4L);
            return value;
        }
    }

    public record UnsignedShortType() implements NetworkBufferTypeImpl<Integer>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Integer value) {
            buffer.ensureWritable(2L);
            NetworkBufferImpl.impl(buffer)._putShort(buffer.writeIndex(), (short)(value & 0xFFFF));
            buffer.advanceWrite(2L);
        }

        @Override
        public Integer read(@NotNull NetworkBuffer buffer) {
            short value = NetworkBufferImpl.impl(buffer)._getShort(buffer.readIndex());
            buffer.advanceRead(2L);
            return value & 0xFFFF;
        }
    }

    public record ShortType() implements NetworkBufferTypeImpl<Short>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Short value) {
            buffer.ensureWritable(2L);
            NetworkBufferImpl.impl(buffer)._putShort(buffer.writeIndex(), value);
            buffer.advanceWrite(2L);
        }

        @Override
        public Short read(@NotNull NetworkBuffer buffer) {
            short value = NetworkBufferImpl.impl(buffer)._getShort(buffer.readIndex());
            buffer.advanceRead(2L);
            return value;
        }
    }

    public record ByteType() implements NetworkBufferTypeImpl<Byte>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Byte value) {
            buffer.ensureWritable(1L);
            NetworkBufferImpl.impl(buffer)._putByte(buffer.writeIndex(), value);
            buffer.advanceWrite(1L);
        }

        @Override
        public Byte read(@NotNull NetworkBuffer buffer) {
            byte value = NetworkBufferImpl.impl(buffer)._getByte(buffer.readIndex());
            buffer.advanceRead(1L);
            return value;
        }
    }

    public record BooleanType() implements NetworkBufferTypeImpl<Boolean>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Boolean value) {
            buffer.ensureWritable(1L);
            NetworkBufferImpl.impl(buffer)._putByte(buffer.writeIndex(), value != false ? (byte)1 : 0);
            buffer.advanceWrite(1L);
        }

        @Override
        public Boolean read(@NotNull NetworkBuffer buffer) {
            byte value = NetworkBufferImpl.impl(buffer)._getByte(buffer.readIndex());
            buffer.advanceRead(1L);
            return value == 1;
        }
    }

    public record UnitType() implements NetworkBufferTypeImpl<Unit>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, Unit value) {
        }

        @Override
        public Unit read(@NotNull NetworkBuffer buffer) {
            return Unit.INSTANCE;
        }
    }
}

