/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.particle;

import java.util.Collection;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.color.AlphaColor;
import net.minestom.server.color.Color;
import net.minestom.server.coordinate.Point;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.particle.ParticleImpl;
import net.minestom.server.particle.Particles;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.utils.block.BlockUtils;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface Particle
extends StaticProtocolObject,
Particles {
    @NotNull
    public static final NetworkBuffer.Type<Particle> NETWORK_TYPE = new NetworkBuffer.Type<Particle>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, Particle value) {
            buffer.write(NetworkBuffer.VAR_INT, value.id());
            value.writeData(buffer);
        }

        @Override
        public Particle read(@NotNull NetworkBuffer buffer) {
            int id = buffer.read(NetworkBuffer.VAR_INT);
            Particle particle = Objects.requireNonNull(Particle.fromId(id), () -> "unknown particle id: " + id);
            return particle.readData(buffer);
        }
    };
    @NotNull
    public static final Codec<Particle> CODEC = new Codec<Particle>(){

        @Override
        @NotNull
        public <D> Result<Particle> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            return new Result.Error<Particle>("particles cannot be decoded");
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Particle value) {
            if (value == null) {
                return new Result.Error("null");
            }
            return value.encode(coder);
        }
    };

    @NotNull
    public static @NotNull Collection<@NotNull Particle> values() {
        return ParticleImpl.values();
    }

    @Nullable
    public static Particle fromKey(@NotNull String key) {
        return ParticleImpl.getSafe(key);
    }

    @Nullable
    public static Particle fromKey(@NotNull Key key) {
        return Particle.fromKey(key.asString());
    }

    @Nullable
    public static Particle fromId(int id) {
        return ParticleImpl.getId(id);
    }

    @NotNull
    public Particle readData(@NotNull NetworkBuffer var1);

    public void writeData(@NotNull NetworkBuffer var1);

    @NotNull
    public <D> Result<D> encode(@NotNull Transcoder<D> var1);

    public record TintedLeaves(@NotNull Key key, int id, @NotNull AlphaColor color) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public TintedLeaves withColor(@NotNull AlphaColor color) {
            return new TintedLeaves(this.key(), this.id(), color);
        }

        @Contract(pure=true)
        @NotNull
        public TintedLeaves withColor(@NotNull RGBLike color) {
            return new TintedLeaves(this.key(), this.id(), new AlphaColor(1, color));
        }

        @Contract(pure=true)
        @NotNull
        public TintedLeaves withColor(int alpha, @NotNull RGBLike color) {
            return new TintedLeaves(this.key(), this.id(), new AlphaColor(alpha, color));
        }

        @Override
        @NotNull
        public TintedLeaves readData(@NotNull NetworkBuffer reader) {
            return this.withColor(reader.read(AlphaColor.NETWORK_TYPE));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(AlphaColor.NETWORK_TYPE, this.color);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            Object colorData;
            Result<D> colorResult = AlphaColor.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t;
                colorData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("color", colorData).build());
        }
    }

    public record BlockCrumble(@NotNull Key key, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Block withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new Block(this.key(), this.id(), block);
        }

        @Override
        @NotNull
        public Block readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(BlockUtils.toString(this.block))).build());
        }
    }

    public record Trail(@NotNull Key key, int id, @NotNull Point target, @NotNull RGBLike color, int duration) implements Particle
    {
        @NotNull
        public Trail withProperties(@NotNull Point target, @NotNull RGBLike color, int duration) {
            return new Trail(this.key(), this.id(), target, color, duration);
        }

        @NotNull
        public Trail withTarget(@NotNull Point target) {
            return new Trail(this.key(), this.id(), target, this.color, this.duration);
        }

        @NotNull
        public Trail withColor(@NotNull RGBLike color) {
            return new Trail(this.key(), this.id(), this.target, color, this.duration);
        }

        @NotNull
        public Trail withDuration(int duration) {
            return new Trail(this.key(), this.id(), this.target, this.color, duration);
        }

        @Override
        @NotNull
        public Trail readData(@NotNull NetworkBuffer reader) {
            return this.withProperties(reader.read(NetworkBuffer.VECTOR3D), reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VECTOR3D, this.target);
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(NetworkBuffer.VAR_INT, this.duration);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            Object t;
            Object colorData;
            Result<D> colorResult = Color.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t2;
                colorData = t2 = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Result<D> targetResult = Codec.VECTOR3D.encode(coder, this.target);
            if (!(targetResult instanceof Result.Ok)) return targetResult.cast();
            ok = (Result.Ok)targetResult;
            Object targetData = t = ok.value();
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("target", targetData).put("color", colorData).build());
        }
    }

    public record Vibration(@NotNull Key key, int id, @NotNull SourceType sourceType, @Nullable Point sourceBlockPosition, int sourceEntityId, float sourceEntityEyeHeight, int travelTicks) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Vibration withProperties(@NotNull SourceType sourceType, @Nullable Point sourceBlockPosition, int sourceEntityId, float sourceEntityEyeHeight, int travelTicks) {
            return new Vibration(this.key(), this.id(), sourceType, sourceBlockPosition, sourceEntityId, sourceEntityEyeHeight, travelTicks);
        }

        @Contract(pure=true)
        @NotNull
        public Vibration withSourceBlockPosition(@Nullable Point sourceBlockPosition, int travelTicks) {
            return new Vibration(this.key(), this.id(), SourceType.BLOCK, sourceBlockPosition, this.sourceEntityId, this.sourceEntityEyeHeight, travelTicks);
        }

        @Contract(pure=true)
        @NotNull
        public Vibration withSourceEntity(int sourceEntityId, float sourceEntityEyeHeight, int travelTicks) {
            return new Vibration(this.key(), this.id(), SourceType.ENTITY, this.sourceBlockPosition, sourceEntityId, sourceEntityEyeHeight, travelTicks);
        }

        @Override
        @NotNull
        public Vibration readData(@NotNull NetworkBuffer reader) {
            SourceType type = reader.read(NetworkBuffer.Enum(SourceType.class));
            if (type == SourceType.BLOCK) {
                return this.withSourceBlockPosition(reader.read(NetworkBuffer.BLOCK_POSITION), reader.read(NetworkBuffer.VAR_INT));
            }
            return this.withSourceEntity(reader.read(NetworkBuffer.VAR_INT), reader.read(NetworkBuffer.FLOAT).floatValue(), reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.Enum(SourceType.class), this.sourceType);
            if (this.sourceType == SourceType.BLOCK) {
                Objects.requireNonNull(this.sourceBlockPosition);
                writer.write(NetworkBuffer.BLOCK_POSITION, this.sourceBlockPosition);
                writer.write(NetworkBuffer.VAR_INT, this.travelTicks);
            } else {
                writer.write(NetworkBuffer.VAR_INT, this.sourceEntityId);
                writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.sourceEntityEyeHeight));
                writer.write(NetworkBuffer.VAR_INT, this.travelTicks);
            }
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            return new Result.Error("Vibration particle cannot be serialized to NBT");
        }

        public static enum SourceType {
            BLOCK,
            ENTITY;

        }
    }

    public record Shriek(@NotNull Key key, int id, int delay) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Shriek withDelay(int delay) {
            return new Shriek(this.key(), this.id(), delay);
        }

        @Override
        @NotNull
        public Shriek readData(@NotNull NetworkBuffer reader) {
            return this.withDelay(reader.read(NetworkBuffer.VAR_INT));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.delay);
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("delay", coder.createInt(this.delay)).build());
        }
    }

    public record SculkCharge(@NotNull Key key, int id, float roll) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public SculkCharge withRoll(float roll) {
            return new SculkCharge(this.key(), this.id(), roll);
        }

        @Override
        @NotNull
        public SculkCharge readData(@NotNull NetworkBuffer reader) {
            return this.withRoll(reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.roll));
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("roll", coder.createFloat(this.roll)).build());
        }
    }

    public record EntityEffect(@NotNull Key key, int id, @NotNull AlphaColor color) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public EntityEffect withColor(@NotNull AlphaColor color) {
            return new EntityEffect(this.key(), this.id(), color);
        }

        @Contract(pure=true)
        @NotNull
        public EntityEffect withColor(@NotNull RGBLike color) {
            return new EntityEffect(this.key(), this.id(), new AlphaColor(1, color));
        }

        @Contract(pure=true)
        @NotNull
        public EntityEffect withColor(int alpha, @NotNull RGBLike color) {
            return new EntityEffect(this.key(), this.id(), new AlphaColor(alpha, color));
        }

        @Override
        @NotNull
        public EntityEffect readData(@NotNull NetworkBuffer reader) {
            return this.withColor(reader.read(AlphaColor.NETWORK_TYPE));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(AlphaColor.NETWORK_TYPE, this.color);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            Object colorData;
            Result<D> colorResult = AlphaColor.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t;
                colorData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("color", colorData).build());
        }
    }

    public record Item(@NotNull Key key, int id, @NotNull ItemStack item) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Item withItem(@NotNull ItemStack item) {
            return new Item(this.key(), this.id(), item);
        }

        @Override
        @NotNull
        public Item readData(@NotNull NetworkBuffer reader) {
            return this.withItem(reader.read(ItemStack.NETWORK_TYPE));
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(ItemStack.NETWORK_TYPE, this.item);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            Object itemData;
            Result<D> itemResult = ItemStack.CODEC.encode(coder, this.item);
            if (!(itemResult instanceof Result.Ok)) return itemResult.cast();
            Result.Ok ok = (Result.Ok)itemResult;
            try {
                Object t;
                itemData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("item", itemData).build());
        }
    }

    public record FallingDust(@NotNull Key key, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public FallingDust withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new FallingDust(this.key(), this.id(), block);
        }

        @Override
        @NotNull
        public FallingDust readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(BlockUtils.toString(this.block))).build());
        }
    }

    public record DustPillar(@NotNull Key key, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public DustPillar withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new DustPillar(this.key(), this.id(), block);
        }

        @Override
        @NotNull
        public DustPillar readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(BlockUtils.toString(this.block))).build());
        }
    }

    public record DustColorTransition(@NotNull Key key, int id, @NotNull RGBLike color, @NotNull RGBLike transitionColor, float scale) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public DustColorTransition withProperties(@NotNull RGBLike color, @NotNull RGBLike transitionColor, float scale) {
            return new DustColorTransition(this.key, this.id, color, transitionColor, scale);
        }

        @Contract(pure=true)
        @NotNull
        public DustColorTransition withColor(@NotNull RGBLike color) {
            return this.withProperties(color, this.transitionColor, this.scale);
        }

        @Contract(pure=true)
        @NotNull
        public DustColorTransition withScale(float scale) {
            return this.withProperties(this.color, this.transitionColor, scale);
        }

        @Contract(pure=true)
        @NotNull
        public DustColorTransition withTransitionColor(@NotNull RGBLike transitionColor) {
            return this.withProperties(this.color, transitionColor, this.scale);
        }

        @Override
        @NotNull
        public DustColorTransition readData(@NotNull NetworkBuffer reader) {
            return this.withProperties(reader.read(Color.NETWORK_TYPE), reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(Color.NETWORK_TYPE, this.transitionColor);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.scale));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            Object t;
            Object fromColorData;
            Result<D> fromColorResult = Color.CODEC.encode(coder, this.color);
            if (!(fromColorResult instanceof Result.Ok)) return fromColorResult.cast();
            Result.Ok ok = (Result.Ok)fromColorResult;
            try {
                Object t2;
                fromColorData = t2 = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Result<D> toColorResult = Color.CODEC.encode(coder, this.transitionColor);
            if (!(toColorResult instanceof Result.Ok)) return toColorResult.cast();
            ok = (Result.Ok)toColorResult;
            Object toColorData = t = ok.value();
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("from_color", fromColorData).put("to_color", toColorData).put("scale", coder.createFloat(this.scale)).build());
        }
    }

    public record Dust(@NotNull Key key, int id, @NotNull RGBLike color, float scale) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Dust withProperties(@NotNull RGBLike color, float scale) {
            return new Dust(this.key(), this.id(), color, scale);
        }

        @Contract(pure=true)
        @NotNull
        public Dust withColor(@NotNull RGBLike color) {
            return this.withProperties(color, this.scale);
        }

        @Contract(pure=true)
        @NotNull
        public Dust withScale(float scale) {
            return this.withProperties(this.color, scale);
        }

        @Override
        @NotNull
        public Dust readData(@NotNull NetworkBuffer reader) {
            return this.withProperties(reader.read(Color.NETWORK_TYPE), reader.read(NetworkBuffer.FLOAT).floatValue());
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(Color.NETWORK_TYPE, this.color);
            writer.write(NetworkBuffer.FLOAT, Float.valueOf(this.scale));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            Object colorData;
            Result<D> colorResult = Color.CODEC.encode(coder, this.color);
            if (!(colorResult instanceof Result.Ok)) return colorResult.cast();
            Result.Ok ok = (Result.Ok)colorResult;
            try {
                Object t;
                colorData = t = ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("color", colorData).put("scale", coder.createFloat(this.scale)).build());
        }
    }

    public record BlockMarker(@NotNull Key key, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public BlockMarker withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new BlockMarker(this.key(), this.id(), block);
        }

        @Override
        @NotNull
        public BlockMarker readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(BlockUtils.toString(this.block))).build());
        }
    }

    public record Block(@NotNull Key key, int id, @NotNull net.minestom.server.instance.block.Block block) implements Particle
    {
        @Contract(pure=true)
        @NotNull
        public Block withBlock(@NotNull net.minestom.server.instance.block.Block block) {
            return new Block(this.key(), this.id(), block);
        }

        @Override
        @NotNull
        public Block readData(@NotNull NetworkBuffer reader) {
            short blockState = reader.read(NetworkBuffer.VAR_INT).shortValue();
            net.minestom.server.instance.block.Block block = net.minestom.server.instance.block.Block.fromStateId(blockState);
            Check.stateCondition(block == null, "Block state " + blockState + " is invalid");
            return this.withBlock(block);
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
            writer.write(NetworkBuffer.VAR_INT, this.block.stateId());
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).put("block_state", coder.createString(BlockUtils.toString(this.block))).build());
        }
    }

    public record Simple(@NotNull Key key, int id) implements Particle
    {
        @Override
        @NotNull
        public Particle readData(@NotNull NetworkBuffer reader) {
            return this;
        }

        @Override
        public void writeData(@NotNull NetworkBuffer writer) {
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder) {
            return new Result.Ok<D>(coder.createMap().put("type", coder.createString(this.key.asString())).build());
        }
    }
}

