/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum RecipeBookCategory implements StaticProtocolObject
{
    CRAFTING_BUILDING_BLOCKS(Key.key((String)"minecraft:crafting_building_blocks")),
    CRAFTING_REDSTONE(Key.key((String)"minecraft:crafting_redstone")),
    CRAFTING_EQUIPMENT(Key.key((String)"minecraft:crafting_equipment")),
    CRAFTING_MISC(Key.key((String)"minecraft:crafting_misc")),
    FURNACE_FOOD(Key.key((String)"minecraft:furnace_food")),
    FURNACE_BLOCKS(Key.key((String)"minecraft:furnace_blocks")),
    FURNACE_MISC(Key.key((String)"minecraft:furnace_misc")),
    BLAST_FURNACE_BLOCKS(Key.key((String)"minecraft:blast_furnace_blocks")),
    BLAST_FURNACE_MISC(Key.key((String)"minecraft:blast_furnace_misc")),
    SMOKER_FOOD(Key.key((String)"minecraft:smoker_food")),
    STONECUTTER(Key.key((String)"minecraft:stonecutter")),
    SMITHING(Key.key((String)"minecraft:smithing")),
    CAMPFIRE(Key.key((String)"minecraft:campfire"));

    private static final Map<Key, RecipeBookCategory> BY_KEY;
    public static final NetworkBuffer.Type<RecipeBookCategory> NETWORK_TYPE;
    public static final Codec<RecipeBookCategory> CODEC;
    private final Key key;

    private RecipeBookCategory(Key key) {
        this.key = key;
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(RecipeBookCategory.values()).collect(Collectors.toMap(RecipeBookCategory::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(RecipeBookCategory.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, RecipeBookCategory::key);
    }
}

