/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryTranscoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface Holder<T> {
    @Nullable
    public T resolve(@NotNull DynamicRegistry<T> var1);

    public static <T> @NotNull NetworkBuffer.Type<Holder<T>> networkType(final @NotNull Registries.Selector<T> selector, final @NotNull NetworkBuffer.Type<T> registryNetworkType) {
        return new NetworkBuffer.Type<Holder<T>>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void write(@NotNull NetworkBuffer buffer, Holder<T> value) {
                Object directValue;
                Registries registries = Objects.requireNonNull(buffer.registries(), "Buffer is missing registries");
                DynamicRegistry registry = selector.select(registries);
                Holder holder = value;
                Objects.requireNonNull(holder);
                Holder holder2 = holder;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Reference.class, Direct.class}, holder2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        int id;
                        Reference reference = (Reference)holder2;
                        try {
                            DynamicRegistry.Key key;
                            DynamicRegistry.Key key2 = key = reference.key();
                            id = registry.getId(key2);
                            if (id == -1) {
                                throw new IllegalArgumentException("Unknown key " + String.valueOf(key2) + " for registry " + String.valueOf(registry));
                            }
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        buffer.write(NetworkBuffer.VAR_INT, id + 1);
                        return;
                    }
                    case 1: 
                }
                Direct direct = (Direct)holder2;
                {
                    Object t;
                    directValue = t = direct.value();
                }
                buffer.write(NetworkBuffer.VAR_INT, 0);
                buffer.write(registryNetworkType, directValue);
            }

            @Override
            public Holder<T> read(@NotNull NetworkBuffer buffer) {
                Registries registries = Objects.requireNonNull(buffer.registries(), "Buffer is missing registries");
                DynamicRegistry<int> registry = selector.select(registries);
                int id = buffer.read(NetworkBuffer.VAR_INT) - 1;
                if (id == -1) {
                    Object value = buffer.read(registryNetworkType);
                    return new Direct(value);
                }
                DynamicRegistry.Key<int> key = registry.getKey(id);
                if (key == null) {
                    throw new IllegalStateException("Unknown id " + id + " for registry " + String.valueOf(registry));
                }
                return new Reference<int>(key);
            }
        };
    }

    @NotNull
    public static <T> Codec<Holder<T>> codec(final @NotNull Registries.Selector<T> selector, final @NotNull Codec<T> registryCodec) {
        return new Codec<Holder<T>>(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @NotNull
            public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Holder<T> value) {
                Object directValue;
                Result.Ok<D> ok;
                if (value == null) {
                    return new Result.Error("null");
                }
                if (!(coder instanceof RegistryTranscoder)) return new Result.Error("Missing registries in transcoder");
                RegistryTranscoder context = (RegistryTranscoder)coder;
                DynamicRegistry registry = selector.select(context.registries());
                Holder holder = value;
                Objects.requireNonNull(holder);
                Holder holder2 = holder;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Reference.class, Direct.class}, holder2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        DynamicRegistry.Key key;
                        Reference reference = (Reference)holder2;
                        try {
                            DynamicRegistry.Key key2;
                            key = key2 = reference.key();
                            if (registry.getId(key) == -1) {
                                throw new IllegalArgumentException("Unknown key " + String.valueOf(key) + " for registry " + String.valueOf(registry));
                            }
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        ok = new Result.Ok<D>(coder.createString(key.name()));
                        return ok;
                    }
                    case 1: 
                }
                Direct direct = (Direct)holder2;
                {
                    Object t;
                    directValue = t = direct.value();
                }
                ok = registryCodec.encode(coder, directValue);
                return ok;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            @NotNull
            public <D> Result<Holder<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
                String reference;
                if (!(coder instanceof RegistryTranscoder)) {
                    return new Result.Error("Missing registries in transcoder");
                }
                RegistryTranscoder context = (RegistryTranscoder)coder;
                DynamicRegistry registry = selector.select(context.registries());
                Result directResult = registryCodec.decode(coder, value);
                if (directResult instanceof Result.Ok) {
                    Object t;
                    Result.Ok ok = (Result.Ok)directResult;
                    Object direct = t = ok.value();
                    return new Result.Ok(new Direct(direct));
                }
                Result<String> referenceResult = coder.getString(value);
                if (!(referenceResult instanceof Result.Ok)) return referenceResult.cast();
                Result.Ok ok = (Result.Ok)referenceResult;
                try {
                    String string;
                    reference = string = (String)ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                return new Result.Ok(new Reference(DynamicRegistry.Key.of(reference)));
            }
        };
    }

    public static <T> @NotNull NetworkBuffer.Type<Lazy<T>> lazyNetworkType(@NotNull Registries.Selector<T> selector, @NotNull NetworkBuffer.Type<T> registryNetworkType) {
        final NetworkBuffer.Type<Holder<T>> holderNetworkType = Holder.networkType(selector, registryNetworkType);
        return new NetworkBuffer.Type<Lazy<T>>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Lazy<T> value) {
                buffer.write(NetworkBuffer.BOOLEAN, value.holder != null);
                if (value.holder != null) {
                    holderNetworkType.write(buffer, value.holder);
                } else {
                    buffer.write(NetworkBuffer.KEY, value.reference);
                }
            }

            @Override
            public Lazy<T> read(@NotNull NetworkBuffer buffer) {
                if (buffer.read(NetworkBuffer.BOOLEAN).booleanValue()) {
                    return new Lazy((Holder)holderNetworkType.read(buffer), null);
                }
                return new Lazy(null, buffer.read(NetworkBuffer.KEY));
            }
        };
    }

    @NotNull
    public static <T> Codec<Lazy<T>> lazyCodec(@NotNull Registries.Selector<T> selector, @NotNull Codec<T> registryCodec) {
        final Codec<Holder<T>> holderCodec = Holder.codec(selector, registryCodec);
        return new Codec<Lazy<T>>(){

            @Override
            @NotNull
            public <D> Result<Lazy<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
                Result<Lazy> holderResult = holderCodec.decode(coder, value).mapResult(Lazy::new);
                if (holderResult instanceof Result.Ok) {
                    Result.Ok ok = (Result.Ok)holderResult;
                    return ok;
                }
                Result<Lazy> referenceResult = Codec.KEY.decode(coder, value).mapResult(Lazy::new);
                if (referenceResult instanceof Result.Ok) {
                    Result.Ok ok = (Result.Ok)referenceResult;
                    return ok;
                }
                return holderResult.cast();
            }

            @Override
            @NotNull
            public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable Lazy<T> value) {
                if (value == null) {
                    return new Result.Error("null");
                }
                return value.holder != null ? holderCodec.encode(coder, value.holder) : Codec.KEY.encode(coder, value.reference);
            }
        };
    }

    public record Lazy<T>(@UnknownNullability Holder<T> holder, @UnknownNullability Key reference) {
        public Lazy(@NotNull Holder<T> holder) {
            this(holder, null);
        }

        public Lazy(@NotNull Key reference) {
            this(null, reference);
        }

        @Nullable
        public T resolve(@NotNull DynamicRegistry<T> registry) {
            return this.holder != null ? this.holder.resolve(registry) : registry.get(this.reference);
        }
    }

    public record Reference<T>(@NotNull DynamicRegistry.Key<T> key) implements Holder<T>
    {
        @Override
        @Nullable
        public T resolve(@NotNull DynamicRegistry<T> registry) {
            return registry.get(this.key);
        }
    }

    public record Direct<T>(@NotNull T value) implements Holder<T>
    {
        @Override
        @NotNull
        public T resolve(@NotNull DynamicRegistry<T> registry) {
            return this.value;
        }
    }
}

