/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.text.Component;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.EntityPose;
import net.minestom.server.entity.MetadataImpl;
import net.minestom.server.entity.metadata.animal.ArmadilloMeta;
import net.minestom.server.entity.metadata.animal.ChickenVariant;
import net.minestom.server.entity.metadata.animal.CowVariant;
import net.minestom.server.entity.metadata.animal.FrogMeta;
import net.minestom.server.entity.metadata.animal.PigVariant;
import net.minestom.server.entity.metadata.animal.SnifferMeta;
import net.minestom.server.entity.metadata.animal.tameable.CatMeta;
import net.minestom.server.entity.metadata.animal.tameable.WolfSoundVariant;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariant;
import net.minestom.server.entity.metadata.other.PaintingVariant;
import net.minestom.server.entity.metadata.villager.VillagerMeta;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.particle.Particle;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.utils.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class Metadata {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(0);
    public static final byte TYPE_BYTE = Metadata.nextId();
    public static final byte TYPE_VARINT = Metadata.nextId();
    public static final byte TYPE_LONG = Metadata.nextId();
    public static final byte TYPE_FLOAT = Metadata.nextId();
    public static final byte TYPE_STRING = Metadata.nextId();
    public static final byte TYPE_CHAT = Metadata.nextId();
    public static final byte TYPE_OPT_CHAT = Metadata.nextId();
    public static final byte TYPE_ITEM_STACK = Metadata.nextId();
    public static final byte TYPE_BOOLEAN = Metadata.nextId();
    public static final byte TYPE_ROTATION = Metadata.nextId();
    public static final byte TYPE_BLOCK_POSITION = Metadata.nextId();
    public static final byte TYPE_OPT_BLOCK_POSITION = Metadata.nextId();
    public static final byte TYPE_DIRECTION = Metadata.nextId();
    public static final byte TYPE_OPT_UUID = Metadata.nextId();
    public static final byte TYPE_BLOCKSTATE = Metadata.nextId();
    public static final byte TYPE_OPT_BLOCKSTATE = Metadata.nextId();
    public static final byte TYPE_NBT = Metadata.nextId();
    public static final byte TYPE_PARTICLE = Metadata.nextId();
    public static final byte TYPE_PARTICLE_LIST = Metadata.nextId();
    public static final byte TYPE_VILLAGERDATA = Metadata.nextId();
    public static final byte TYPE_OPT_VARINT = Metadata.nextId();
    public static final byte TYPE_POSE = Metadata.nextId();
    public static final byte TYPE_CAT_VARIANT = Metadata.nextId();
    public static final byte TYPE_COW_VARIANT = Metadata.nextId();
    public static final byte TYPE_WOLF_VARIANT = Metadata.nextId();
    public static final byte TYPE_WOLF_SOUND_VARIANT = Metadata.nextId();
    public static final byte TYPE_FROG_VARIANT = Metadata.nextId();
    public static final byte TYPE_PIG_VARIANT = Metadata.nextId();
    public static final byte TYPE_CHICKEN_VARIANT = Metadata.nextId();
    public static final byte TYPE_OPT_GLOBAL_POSITION = Metadata.nextId();
    public static final byte TYPE_PAINTING_VARIANT = Metadata.nextId();
    public static final byte TYPE_SNIFFER_STATE = Metadata.nextId();
    public static final byte TYPE_ARMADILLO_STATE = Metadata.nextId();
    public static final byte TYPE_VECTOR3 = Metadata.nextId();
    public static final byte TYPE_QUATERNION = Metadata.nextId();

    public static Entry<Byte> Byte(byte value) {
        return new MetadataImpl.EntryImpl<Byte>(TYPE_BYTE, value, NetworkBuffer.BYTE);
    }

    public static Entry<Integer> VarInt(int value) {
        return new MetadataImpl.EntryImpl<Integer>(TYPE_VARINT, value, NetworkBuffer.VAR_INT);
    }

    public static Entry<Long> VarLong(long value) {
        return new MetadataImpl.EntryImpl<Long>(TYPE_LONG, value, NetworkBuffer.VAR_LONG);
    }

    public static Entry<Float> Float(float value) {
        return new MetadataImpl.EntryImpl<Float>(TYPE_FLOAT, Float.valueOf(value), NetworkBuffer.FLOAT);
    }

    public static Entry<String> String(@NotNull String value) {
        return new MetadataImpl.EntryImpl<String>(TYPE_STRING, value, NetworkBuffer.STRING);
    }

    public static Entry<Component> Chat(@NotNull Component value) {
        return new MetadataImpl.EntryImpl<Component>(TYPE_CHAT, value, NetworkBuffer.COMPONENT);
    }

    public static Entry<Component> OptChat(@Nullable Component value) {
        return new MetadataImpl.EntryImpl<Component>(TYPE_OPT_CHAT, value, NetworkBuffer.OPT_CHAT);
    }

    public static Entry<ItemStack> ItemStack(@NotNull ItemStack value) {
        return new MetadataImpl.EntryImpl<ItemStack>(TYPE_ITEM_STACK, value, ItemStack.NETWORK_TYPE);
    }

    public static Entry<Boolean> Boolean(boolean value) {
        return new MetadataImpl.EntryImpl<Boolean>(TYPE_BOOLEAN, value, NetworkBuffer.BOOLEAN);
    }

    public static Entry<Point> Rotation(@NotNull Point value) {
        return new MetadataImpl.EntryImpl<Point>(TYPE_ROTATION, value, NetworkBuffer.VECTOR3);
    }

    public static Entry<Point> BlockPosition(@NotNull Point value) {
        return new MetadataImpl.EntryImpl<Point>(TYPE_BLOCK_POSITION, value, NetworkBuffer.BLOCK_POSITION);
    }

    public static Entry<Point> OptBlockPosition(@Nullable Point value) {
        return new MetadataImpl.EntryImpl<Point>(TYPE_OPT_BLOCK_POSITION, value, NetworkBuffer.OPT_BLOCK_POSITION);
    }

    public static Entry<Direction> Direction(@NotNull Direction value) {
        return new MetadataImpl.EntryImpl<Direction>(TYPE_DIRECTION, value, NetworkBuffer.DIRECTION);
    }

    public static Entry<UUID> OptUUID(@Nullable UUID value) {
        return new MetadataImpl.EntryImpl<UUID>(TYPE_OPT_UUID, value, NetworkBuffer.OPT_UUID);
    }

    public static Entry<Block> BlockState(@NotNull Block value) {
        return new MetadataImpl.EntryImpl<Block>(TYPE_BLOCKSTATE, value, Block.NETWORK_TYPE);
    }

    public static Entry<Integer> OptBlockState(@Nullable Integer value) {
        return new MetadataImpl.EntryImpl<Integer>(TYPE_OPT_BLOCKSTATE, value, new NetworkBuffer.Type<Integer>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Integer value) {
                buffer.write(NetworkBuffer.VAR_INT, value == null ? 0 : value);
            }

            @Override
            public Integer read(@NotNull NetworkBuffer buffer) {
                int value = buffer.read(NetworkBuffer.VAR_INT);
                return value == 0 ? null : Integer.valueOf(value);
            }
        });
    }

    public static Entry<BinaryTag> NBT(@NotNull BinaryTag nbt) {
        return new MetadataImpl.EntryImpl<BinaryTag>(TYPE_NBT, nbt, NetworkBuffer.NBT);
    }

    public static Entry<Particle> Particle(@NotNull Particle particle) {
        return new MetadataImpl.EntryImpl<Particle>(TYPE_PARTICLE, particle, Particle.NETWORK_TYPE);
    }

    public static Entry<List<Particle>> ParticleList(@NotNull List<Particle> particles) {
        return new MetadataImpl.EntryImpl<List<Particle>>(TYPE_PARTICLE_LIST, particles, Particle.NETWORK_TYPE.list(Short.MAX_VALUE));
    }

    public static Entry<VillagerMeta.VillagerData> VillagerData(@NotNull VillagerMeta.VillagerData data) {
        return new MetadataImpl.EntryImpl<VillagerMeta.VillagerData>(TYPE_VILLAGERDATA, data, VillagerMeta.VillagerData.NETWORK_TYPE);
    }

    public static Entry<Integer> OptVarInt(@Nullable Integer value) {
        return new MetadataImpl.EntryImpl<Integer>(TYPE_OPT_VARINT, value, new NetworkBuffer.Type<Integer>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Integer value) {
                buffer.write(NetworkBuffer.VAR_INT, value == null ? 0 : value + 1);
            }

            @Override
            public Integer read(@NotNull NetworkBuffer buffer) {
                int value = buffer.read(NetworkBuffer.VAR_INT);
                return value == 0 ? null : Integer.valueOf(value - 1);
            }
        });
    }

    public static Entry<EntityPose> Pose(@NotNull EntityPose value) {
        return new MetadataImpl.EntryImpl<EntityPose>(TYPE_POSE, value, NetworkBuffer.POSE);
    }

    public static Entry<CatMeta.Variant> CatVariant(@NotNull CatMeta.Variant value) {
        return new MetadataImpl.EntryImpl<CatMeta.Variant>(TYPE_CAT_VARIANT, value, CatMeta.Variant.NETWORK_TYPE);
    }

    public static Entry<RegistryKey<CowVariant>> CowVariant(@NotNull RegistryKey<CowVariant> value) {
        return new MetadataImpl.EntryImpl<RegistryKey<CowVariant>>(TYPE_COW_VARIANT, value, CowVariant.NETWORK_TYPE);
    }

    public static Entry<RegistryKey<WolfVariant>> WolfVariant(@NotNull RegistryKey<WolfVariant> value) {
        return new MetadataImpl.EntryImpl<RegistryKey<WolfVariant>>(TYPE_WOLF_VARIANT, value, WolfVariant.NETWORK_TYPE);
    }

    public static Entry<RegistryKey<WolfSoundVariant>> WolfSoundVariant(@NotNull RegistryKey<WolfSoundVariant> value) {
        return new MetadataImpl.EntryImpl<RegistryKey<WolfSoundVariant>>(TYPE_WOLF_SOUND_VARIANT, value, WolfSoundVariant.NETWORK_TYPE);
    }

    public static Entry<FrogMeta.Variant> FrogVariant(@NotNull FrogMeta.Variant value) {
        return new MetadataImpl.EntryImpl<FrogMeta.Variant>(TYPE_FROG_VARIANT, value, FrogMeta.Variant.NETWORK_TYPE);
    }

    public static Entry<RegistryKey<PigVariant>> PigVariant(@NotNull RegistryKey<PigVariant> value) {
        return new MetadataImpl.EntryImpl<RegistryKey<PigVariant>>(TYPE_PIG_VARIANT, value, PigVariant.NETWORK_TYPE);
    }

    public static Entry<RegistryKey<ChickenVariant>> ChickenVariant(@NotNull RegistryKey<ChickenVariant> value) {
        return new MetadataImpl.EntryImpl<RegistryKey<ChickenVariant>>(TYPE_CHICKEN_VARIANT, value, ChickenVariant.NETWORK_TYPE);
    }

    public static Entry<Holder<PaintingVariant>> PaintingVariant(@NotNull Holder<PaintingVariant> value) {
        return new MetadataImpl.EntryImpl<Holder<PaintingVariant>>(TYPE_PAINTING_VARIANT, value, PaintingVariant.NETWORK_TYPE);
    }

    public static Entry<SnifferMeta.State> SnifferState(@NotNull SnifferMeta.State value) {
        return new MetadataImpl.EntryImpl<SnifferMeta.State>(TYPE_SNIFFER_STATE, value, SnifferMeta.State.NETWORK_TYPE);
    }

    public static Entry<ArmadilloMeta.State> ArmadilloState(@NotNull ArmadilloMeta.State value) {
        return new MetadataImpl.EntryImpl<ArmadilloMeta.State>(TYPE_ARMADILLO_STATE, value, ArmadilloMeta.State.NETWORK_TYPE);
    }

    public static Entry<Point> Vector3(@NotNull Point value) {
        return new MetadataImpl.EntryImpl<Point>(TYPE_VECTOR3, value, NetworkBuffer.VECTOR3);
    }

    public static Entry<float[]> Quaternion(float @NotNull [] value) {
        return new MetadataImpl.EntryImpl<float[]>(TYPE_QUATERNION, value, NetworkBuffer.QUATERNION);
    }

    private static byte nextId() {
        return (byte)NEXT_ID.getAndIncrement();
    }

    public static sealed interface Entry<T>
    permits MetadataImpl.EntryImpl {
        public static final NetworkBuffer.Type<Entry<?>> SERIALIZER = MetadataImpl.EntryImpl.SERIALIZER;

        public int type();

        public @UnknownNullability T value();
    }
}

