/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum VillagerType implements StaticProtocolObject
{
    DESERT(Key.key((String)"minecraft:desert")),
    JUNGLE(Key.key((String)"minecraft:jungle")),
    PLAINS(Key.key((String)"minecraft:plains")),
    SAVANNA(Key.key((String)"minecraft:savanna")),
    SNOW(Key.key((String)"minecraft:snow")),
    SWAMP(Key.key((String)"minecraft:swamp")),
    TAIGA(Key.key((String)"minecraft:taiga"));

    private static final Map<Key, VillagerType> BY_KEY;
    public static final NetworkBuffer.Type<VillagerType> NETWORK_TYPE;
    public static final Codec<VillagerType> CODEC;
    private final Key key;

    private VillagerType(Key key) {
        this.key = key;
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(VillagerType.values()).collect(Collectors.toMap(VillagerType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(VillagerType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, VillagerType::key);
    }
}

