/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.tag.Tag;
import net.minestom.server.utils.block.BlockUtils;
import net.minestom.server.utils.collection.MergedMap;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.annotations.Unmodifiable;

final class BlockImpl
extends Record
implements Block {
    @NotNull
    private final RegistryData.BlockEntry registry;
    private final long propertiesArray;
    @Nullable
    private final CompoundBinaryTag nbt;
    @Nullable
    private final BlockHandler handler;
    private static final int BITS_PER_INDEX = 5;
    private static final int MAX_STATES = 12;
    private static final int MAX_VALUES = 32;
    private static final ObjectArray<Block> BLOCK_STATE_MAP = ObjectArray.singleThread();
    private static final ObjectArray<PropertyType[]> PROPERTIES_TYPE = ObjectArray.singleThread();
    private static final ObjectArray<Long2ObjectArrayMap<BlockImpl>> POSSIBLE_STATES = ObjectArray.singleThread();
    static final Registry<Block> REGISTRY = RegistryData.createStaticRegistry(Key.key((String)"minecraft:block"), (namespace, properties) -> {
        PropertyType[] propertyTypes;
        int blockId = properties.getInt("id");
        RegistryData.Properties stateObject = properties.section("states");
        RegistryData.Properties stateProperties = properties.section("properties");
        if (stateProperties != null) {
            int stateCount = stateProperties.size();
            if (stateCount > 12) {
                throw new IllegalStateException("Too many properties for block " + namespace);
            }
            propertyTypes = new PropertyType[stateCount];
            int i = 0;
            for (Map.Entry<String, Object> entry : stateProperties) {
                String k = entry.getKey();
                List v = (List)entry.getValue();
                assert (v.size() < 32);
                propertyTypes[i++] = new PropertyType(k, v);
            }
        } else {
            propertyTypes = new PropertyType[]{};
        }
        PROPERTIES_TYPE.set(blockId, propertyTypes);
        int propertiesCount = stateObject.size();
        long[] propertiesKeys = new long[propertiesCount];
        Object[] blocksValues = new BlockImpl[propertiesCount];
        int propertiesOffset = 0;
        for (Map.Entry<String, Object> stateEntry : stateObject) {
            String query = stateEntry.getKey();
            Map stateOverride = (Map)stateEntry.getValue();
            Map<String, String> propertyMap = BlockUtils.parseProperties(query);
            assert (propertyTypes.length == propertyMap.size());
            long propertiesValue = 0L;
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                byte keyIndex = BlockImpl.findKeyIndex(propertyTypes, entry.getKey(), null);
                byte valueIndex = BlockImpl.findValueIndex(propertyTypes[keyIndex], entry.getValue(), null);
                propertiesValue = BlockImpl.updateIndex(propertiesValue, keyIndex, valueIndex);
            }
            RegistryData.Properties mainProperties = RegistryData.Properties.fromMap(new MergedMap<String, Object>(stateOverride, properties.asMap()));
            BlockImpl block = new BlockImpl(RegistryData.block(namespace, mainProperties), propertiesValue, null, null);
            BLOCK_STATE_MAP.set(block.stateId(), block);
            propertiesKeys[propertiesOffset] = propertiesValue;
            blocksValues[propertiesOffset++] = block;
        }
        POSSIBLE_STATES.set(blockId, (Long2ObjectArrayMap<BlockImpl>)new Long2ObjectArrayMap(propertiesKeys, blocksValues, propertiesOffset));
        int defaultState = properties.getInt("defaultStateId");
        return BlockImpl.getState(defaultState);
    });

    BlockImpl(@NotNull RegistryData.BlockEntry registry, long propertiesArray, @Nullable CompoundBinaryTag nbt, @Nullable BlockHandler handler) {
        this.registry = registry;
        this.propertiesArray = propertiesArray;
        this.nbt = nbt;
        this.handler = handler;
    }

    static @UnknownNullability Block get(@NotNull String key) {
        return REGISTRY.get(Key.key((String)key));
    }

    static Block getState(int stateId) {
        return BLOCK_STATE_MAP.get(stateId);
    }

    @Override
    @NotNull
    public Block withProperty(@NotNull String property, @NotNull String value) {
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        assert (propertyTypes != null);
        byte keyIndex = BlockImpl.findKeyIndex(propertyTypes, property, this);
        byte valueIndex = BlockImpl.findValueIndex(propertyTypes[keyIndex], value, this);
        long updatedProperties = BlockImpl.updateIndex(this.propertiesArray, keyIndex, valueIndex);
        return this.compute(updatedProperties);
    }

    @Override
    @NotNull
    public Block withProperties(@NotNull @NotNull Map<@NotNull String, @NotNull String> properties) {
        if (properties.isEmpty()) {
            return this;
        }
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        assert (propertyTypes != null);
        long updatedProperties = this.propertiesArray;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            byte keyIndex = BlockImpl.findKeyIndex(propertyTypes, entry.getKey(), this);
            byte valueIndex = BlockImpl.findValueIndex(propertyTypes[keyIndex], entry.getValue(), this);
            updatedProperties = BlockImpl.updateIndex(updatedProperties, keyIndex, valueIndex);
        }
        return this.compute(updatedProperties);
    }

    @Override
    @NotNull
    public <T> Block withTag(@NotNull Tag<T> tag, @Nullable T value) {
        CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
        if (this.nbt != null) {
            builder.put(this.nbt);
        }
        tag.write(builder, value);
        CompoundBinaryTag temporaryNbt = builder.build();
        CompoundBinaryTag finalNbt = temporaryNbt.size() > 0 ? temporaryNbt : null;
        return new BlockImpl(this.registry, this.propertiesArray, finalNbt, this.handler);
    }

    @Override
    @NotNull
    public Block withNbt(@Nullable CompoundBinaryTag compound) {
        return new BlockImpl(this.registry, this.propertiesArray, compound, this.handler);
    }

    @Override
    @NotNull
    public Block withHandler(@Nullable BlockHandler handler) {
        return new BlockImpl(this.registry, this.propertiesArray, this.nbt, handler);
    }

    @Override
    public @Unmodifiable @NotNull Map<String, String> properties() {
        PropertyType[] propertyTypes = PROPERTIES_TYPE.get(this.id());
        assert (propertyTypes != null);
        int length = propertyTypes.length;
        if (length == 0) {
            return Map.of();
        }
        Object[] keys = new String[length];
        Object[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            PropertyType property = propertyTypes[i];
            keys[i] = property.key();
            long index = BlockImpl.extractIndex(this.propertiesArray, i);
            values[i] = property.values().get((int)index);
        }
        return Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectArrayMap(keys, values, length));
    }

    @Override
    @NotNull
    public Block defaultState() {
        return Block.fromBlockId(this.id());
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Block> possibleStates() {
        return (Collection)Collection.class.cast(this.possibleProperties().values());
    }

    @Override
    public <T> @UnknownNullability T getTag(@NotNull Tag<T> tag) {
        return tag.read(Objects.requireNonNullElse(this.nbt, CompoundBinaryTag.empty()));
    }

    private Long2ObjectArrayMap<BlockImpl> possibleProperties() {
        return POSSIBLE_STATES.get(this.id());
    }

    @Override
    public String toString() {
        return String.format("%s{properties=%s, nbt=%s, handler=%s}", this.name(), this.properties(), this.nbt, this.handler);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockImpl)) {
            return false;
        }
        BlockImpl block = (BlockImpl)o;
        return this.stateId() == block.stateId() && Objects.equals(this.nbt, block.nbt) && Objects.equals(this.handler, block.handler);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.stateId(), this.nbt, this.handler);
    }

    private Block compute(long updatedProperties) {
        if (updatedProperties == this.propertiesArray) {
            return this;
        }
        BlockImpl block = (BlockImpl)this.possibleProperties().get(updatedProperties);
        assert (block != null);
        if (this.nbt == null && this.handler == null) {
            return block;
        }
        return new BlockImpl(block.registry(), block.propertiesArray, this.nbt, this.handler);
    }

    private static byte findKeyIndex(PropertyType[] properties, String key, BlockImpl block) {
        for (byte i = 0; i < properties.length; i = (byte)(i + 1)) {
            if (!properties[i].key().equals(key)) continue;
            return i;
        }
        if (block != null) {
            throw new IllegalArgumentException("Property " + key + " is not valid for block " + String.valueOf(block));
        }
        throw new IllegalArgumentException("Unknown property key: " + key);
    }

    private static byte findValueIndex(PropertyType propertyType, String value, BlockImpl block) {
        List<String> values = propertyType.values();
        byte index = (byte)values.indexOf(value);
        if (index != -1) {
            return index;
        }
        if (block != null) {
            throw new IllegalArgumentException("Property " + propertyType.key() + " value " + value + " is not valid for block " + String.valueOf(block));
        }
        throw new IllegalArgumentException("Unknown property value: " + value);
    }

    static long updateIndex(long value, int index, byte newValue) {
        int position = index * 5;
        int mask = 31;
        value &= 31L << position ^ 0xFFFFFFFFFFFFFFFFL;
        return value |= (long)(newValue & 0x1F) << position;
    }

    static long extractIndex(long value, int index) {
        int position = index * 5;
        int mask = 31;
        return value >> position & 0x1FL;
    }

    @Override
    @NotNull
    public RegistryData.BlockEntry registry() {
        return this.registry;
    }

    public long propertiesArray() {
        return this.propertiesArray;
    }

    @Override
    @Nullable
    public CompoundBinaryTag nbt() {
        return this.nbt;
    }

    @Override
    @Nullable
    public BlockHandler handler() {
        return this.handler;
    }

    static {
        PROPERTIES_TYPE.trim();
        BLOCK_STATE_MAP.trim();
        POSSIBLE_STATES.trim();
    }

    private record PropertyType(String key, List<String> values) {
    }
}

