/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.predicate;

import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.predicate.DataComponentPredicates;
import net.minestom.server.instance.block.predicate.PropertiesPredicate;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryTag;
import net.minestom.server.utils.block.BlockUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record BlockPredicate(@Nullable RegistryTag<Block> blocks, @Nullable PropertiesPredicate state, @Nullable CompoundBinaryTag nbt, @NotNull DataComponentPredicates components) implements Predicate<Block>
{
    public static final BlockPredicate ALL = new BlockPredicate(null, null, null);
    public static final BlockPredicate NONE = new BlockPredicate(null, new PropertiesPredicate(Map.of("no_such_property", new PropertiesPredicate.ValuePredicate.Exact("never"))), null);
    public static final NetworkBuffer.Type<BlockPredicate> NETWORK_TYPE = NetworkBufferTemplate.template(RegistryTag.networkType(Registries::blocks).optional(), BlockPredicate::blocks, PropertiesPredicate.NETWORK_TYPE.optional(), BlockPredicate::state, NetworkBuffer.NBT_COMPOUND.optional(), BlockPredicate::nbt, DataComponentPredicates.NETWORK_TYPE, BlockPredicate::components, BlockPredicate::new);
    public static final StructCodec<BlockPredicate> CODEC = StructCodec.struct("blocks", RegistryTag.codec(Registries::blocks).optional(), BlockPredicate::blocks, "state", PropertiesPredicate.CODEC.optional(), BlockPredicate::state, "nbt", Codec.NBT_COMPOUND.optional(), BlockPredicate::nbt, "$$inline$$", DataComponentPredicates.CODEC, BlockPredicate::components, BlockPredicate::new);

    public BlockPredicate(@NotNull RegistryTag<Block> blocks) {
        this(blocks, null, null);
    }

    public BlockPredicate(Block ... blocks) {
        this(RegistryTag.direct(blocks));
    }

    public BlockPredicate(@NotNull PropertiesPredicate state) {
        this(null, state, null);
    }

    public BlockPredicate(@NotNull CompoundBinaryTag nbt) {
        this(null, null, nbt);
    }

    public BlockPredicate(@Nullable RegistryTag<Block> blocks, @Nullable PropertiesPredicate state, @Nullable CompoundBinaryTag nbt) {
        this(blocks, state, nbt, DataComponentPredicates.EMPTY);
    }

    @Override
    public boolean test(@NotNull Block block) {
        if (this.blocks != null && !this.blocks.contains(block)) {
            return false;
        }
        if (this.state != null && !this.state.test(block)) {
            return false;
        }
        return this.nbt == null || Objects.equals(this.nbt, BlockUtils.extractClientNbt(block));
    }
}

