/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.HashMap;
import java.util.Map;
import net.minestom.server.codec.Codec;
import net.minestom.server.item.enchant.Enchantment;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.RegistryKey;
import org.jetbrains.annotations.NotNull;

public record EnchantmentList(@NotNull Map<RegistryKey<Enchantment>, Integer> enchantments) {
    public static final EnchantmentList EMPTY = new EnchantmentList(Map.of());
    public static final NetworkBuffer.Type<EnchantmentList> NETWORK_TYPE = NetworkBufferTemplate.template(Enchantment.NETWORK_TYPE.mapValue(NetworkBuffer.VAR_INT, Short.MAX_VALUE), EnchantmentList::enchantments, EnchantmentList::new);
    public static final Codec<EnchantmentList> CODEC = Enchantment.CODEC.mapValue(Codec.INT, Short.MAX_VALUE).transform(EnchantmentList::new, EnchantmentList::enchantments);

    public EnchantmentList(@NotNull Map<RegistryKey<Enchantment>, Integer> enchantments) {
        enchantments = Map.copyOf(enchantments);
    }

    public EnchantmentList(@NotNull RegistryKey<Enchantment> enchantment, int level) {
        this(Map.of(enchantment, level));
    }

    public boolean has(@NotNull RegistryKey<Enchantment> enchantment) {
        return this.enchantments.containsKey(enchantment);
    }

    public int level(@NotNull RegistryKey<Enchantment> enchantment) {
        return this.enchantments.getOrDefault(enchantment, 0);
    }

    @NotNull
    public EnchantmentList with(@NotNull RegistryKey<Enchantment> enchantment, int level) {
        HashMap<RegistryKey<Enchantment>, Integer> newEnchantments = new HashMap<RegistryKey<Enchantment>, Integer>(this.enchantments);
        newEnchantments.put(enchantment, level);
        return new EnchantmentList(newEnchantments);
    }

    @NotNull
    public EnchantmentList remove(@NotNull RegistryKey<Enchantment> enchantment) {
        HashMap<RegistryKey<Enchantment>, Integer> newEnchantments = new HashMap<RegistryKey<Enchantment>, Integer>(this.enchantments);
        newEnchantments.remove(enchantment);
        return new EnchantmentList(newEnchantments);
    }
}

