/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.component;

import java.util.HashMap;
import java.util.Map;
import net.minestom.server.codec.Codec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public record ItemBlockState(@NotNull Map<String, String> properties) {
    public static final ItemBlockState EMPTY = new ItemBlockState(Map.of());
    public static final NetworkBuffer.Type<ItemBlockState> NETWORK_TYPE = NetworkBuffer.STRING.mapValue(NetworkBuffer.STRING).transform(ItemBlockState::new, ItemBlockState::properties);
    public static final Codec<ItemBlockState> CODEC = Codec.STRING.mapValue(Codec.STRING).transform(ItemBlockState::new, ItemBlockState::properties);

    public ItemBlockState(@NotNull Map<String, String> properties) {
        properties = Map.copyOf(properties);
    }

    @NotNull
    public ItemBlockState with(@NotNull String key, @NotNull String value) {
        HashMap<String, String> newProperties = new HashMap<String, String>(this.properties);
        newProperties.put(key, value);
        return new ItemBlockState(newProperties);
    }

    @NotNull
    public Block apply(@NotNull Block block) {
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (block.getProperty(entry.getKey()) == null) continue;
            block = block.withProperty(entry.getKey(), entry.getValue());
        }
        return block;
    }
}

